/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.block.CursedDirt;
import io.github.lucaargolo.kibe.blockentity.BigTorchBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public abstract class MobSpawnerLogicMixin {
    @Inject(at={@At(value="HEAD")}, method={"isNearPlayer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true)
    private void isPlayerInRange(Level world, BlockPos blockPos, CallbackInfoReturnable<Boolean> info) {
        boolean returnValue = world.getBlockState(blockPos.below()).getBlock() instanceof CursedDirt;
        if (returnValue) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"})
    private void serverTickHead(ServerLevel world, BlockPos blockPos, CallbackInfo ci) {
        if (world.getBlockState(blockPos.below()).getBlock() instanceof CursedDirt) {
            BigTorchBlockEntity.Companion.setException(true);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"})
    private void serverTickTail(ServerLevel world, BlockPos blockPos, CallbackInfo ci) {
        BigTorchBlockEntity.Companion.setException(false);
    }
}

