/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.block.Elevator;
import io.github.lucaargolo.kibe.effect.EffectCompendium;
import io.github.lucaargolo.kibe.enchantment.EnchantmentCompendium;
import io.github.lucaargolo.kibe.item.Glider;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import io.github.lucaargolo.kibe.item.SleepingBag;
import io.github.lucaargolo.kibe.mixed.LivingEntityMixed;
import io.github.lucaargolo.kibe.utils.SlimeBounceHandler;
import io.github.lucaargolo.kibe.utils.helper.SpikeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityMixed {
    private static final EntityDataAccessor<Boolean> CURSED = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Shadow
    public abstract boolean randomTeleport(double var1, double var3, double var5, boolean var7);

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"})
    private void initDataTracker(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(CURSED, (Object)false);
    }

    @Inject(at={@At(value="HEAD")}, method={"onEffectAdded(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)V"})
    private void addStatusEffect(MobEffectInstance effect, Entity source, CallbackInfo ci) {
        if (effect.getEffect().equals(EffectCompendium.INSTANCE.getCURSED())) {
            this.entityData.set(CURSED, (Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"})
    private void removeStatusEffect(MobEffectInstance effect, CallbackInfo ci) {
        if (effect.getEffect().equals(EffectCompendium.INSTANCE.getCURSED())) {
            this.entityData.set(CURSED, (Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void afterReadNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.hasEffect((Holder<MobEffect>)EffectCompendium.INSTANCE.getCURSED())) {
            this.entityData.set(CURSED, (Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, cancellable=true)
    private void swingHand(InteractionHand hand, CallbackInfo info) {
        ItemStack stack = this.getItemInHand(hand);
        if (stack.getItem() instanceof Glider && Glider.Companion.isEnabled(stack)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"checkBedExists()Z"}, cancellable=true)
    private void isSleepingInBed(CallbackInfoReturnable<Boolean> info) {
        if (SleepingBag.Companion.getPlayersSleeping().contains(this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jumpFromGround()V"})
    private void jump(CallbackInfo info) {
        BlockPos pos = this.blockPosition();
        Block block = this.level().getBlockState(pos.below()).getBlock();
        if (block instanceof Elevator && this.level().getBlockState(pos).getCollisionShape((BlockGetter)this.level(), pos).isEmpty()) {
            while (pos.getY() < this.level().getMaxBuildHeight()) {
                if (this.level().getBlockState(pos.above()).getBlock().equals(block) && Elevator.Companion.isElevatorValid(this.level(), pos.above())) {
                    this.level().playSound(null, this.blockPosition(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, this.level().random.nextFloat() * 0.25f + 0.6f);
                    this.randomTeleport(this.position().x, (double)pos.above().getY() + 1.15, this.position().z, false);
                    this.level().playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, this.level().random.nextFloat() * 0.25f + 0.6f);
                    break;
                }
                pos = pos.above();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"})
    private void handleFallDamage(float fallDistance, float damageMultiplier, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof Player) {
            boolean isSlimy;
            Player player = (Player)this;
            ItemStack feetStack = player.getItemBySlot(EquipmentSlot.FEET);
            boolean bl = isSlimy = feetStack.getItem() == ItemCompendium.INSTANCE.getSLIME_BOOTS();
            if (!isSlimy) {
                isSlimy = feetStack.getEnchantments().keySet().stream().anyMatch(enchantment -> EnchantmentCompendium.INSTANCE.getSLIMY().equals(enchantment.unwrapKey().orElse(null)));
            }
            if (isSlimy) {
                if (!this.isShiftKeyDown() && fallDistance > 2.0f) {
                    this.fallDistance = 0.0f;
                    if (this.level().isClientSide) {
                        this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y * -0.9, this.getDeltaMovement().z);
                        this.hasImpulse = true;
                        this.setOnGround(false);
                        double f = 0.9500000000000001;
                        this.setDeltaMovement(this.getDeltaMovement().x / f, this.getDeltaMovement().y, this.getDeltaMovement().z / f);
                    } else {
                        info.cancel();
                    }
                    this.playSound(SoundEvents.SLIME_SQUISH, 1.0f, 1.0f);
                    SlimeBounceHandler.Companion.addBounceHandler((LivingEntity)player, this.getDeltaMovement().y);
                } else if (!this.level().isClientSide && this.isShiftKeyDown() && fallDistance > 5.0f) {
                    this.fallDistance = 5.0f;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDropLoot()Z"}, cancellable=true)
    private void shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (SpikeHelper.INSTANCE.shouldCancelLootDrop(livingEntity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean kibe$isCursed() {
        return (Boolean)this.entityData.get(CURSED);
    }
}

