/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.lucaargolo.kibe.item.Glider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public class HeldItemRendererMixin {
    @Shadow
    private ItemStack offHandItem;
    @Shadow
    private ItemStack mainHandItem;
    @Shadow
    private float mainHandHeight;
    @Shadow
    private float offHandHeight;
    @Shadow
    private float oOffHandHeight;
    @Shadow
    private float oMainHandHeight;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void updateHeldItems(CallbackInfo info) {
        assert (this.minecraft.player != null);
        ItemStack mainHandStack = this.minecraft.player.getMainHandItem();
        ItemStack offHandStack = this.minecraft.player.getOffhandItem();
        if (offHandStack.getItem() instanceof Glider) {
            this.offHandItem = offHandStack;
            this.offHandHeight = 1.0f;
            this.oOffHandHeight = 1.0f;
        }
        if (this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof Glider) {
            this.mainHandItem = mainHandStack;
            this.mainHandHeight = 1.0f;
            this.oMainHandHeight = 1.0f;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void renderFirstPersonItemPre(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        if (player.getItemInHand(hand).getItem() instanceof Glider && Glider.Companion.isEnabled(player.getItemInHand(hand))) {
            matrices.pushPose();
            matrices.mulPose(Axis.XN.rotationDegrees(360.0f - player.getViewXRot(tickDelta)));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void renderFirstPersonItemPost(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack item, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        if (player.getItemInHand(hand).getItem() instanceof Glider && Glider.Companion.isEnabled(player.getItemInHand(hand))) {
            matrices.popPose();
        }
    }
}

