/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.item.ItemCompendium;
import io.github.lucaargolo.kibe.utils.FakeClientPlayerEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/github/lucaargolo/kibe/item/VoidBucket;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "", "fakeInteraction", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/BlockHitResult;)Z", "kibe"})
public final class VoidBucket
extends Item {
    public VoidBucket(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @Nullable InteractionHand hand) {
        BlockHitResult blockHitResult;
        block8: {
            ItemStack itemStack;
            block7: {
                BlockState blockState;
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                itemStack = user.getItemInHand(hand);
                BlockHitResult blockHitResult2 = Item.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                Intrinsics.checkNotNullExpressionValue((Object)blockHitResult2, (String)"raycast(...)");
                HitResult hitResult = (HitResult)blockHitResult2;
                blockHitResult = (BlockHitResult)hitResult;
                if (blockHitResult == null) break block7;
                BlockHitResult blockHitResult3 = blockHitResult;
                boolean bl = false;
                Direction dir = blockHitResult3.getDirection();
                BlockPos pos = blockHitResult3.getBlockPos();
                BlockPos offsetPos = pos.relative(dir);
                Intrinsics.checkNotNull((Object)pos);
                if (this.fakeInteraction(world, pos, blockHitResult3)) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)itemStack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                    return interactionResultHolder;
                }
                if (world.mayInteract(user, pos) && user.mayUseItemAt(offsetPos, dir, itemStack) && (blockState = world.getBlockState(pos)).getBlock() instanceof BucketPickup) {
                    Block block = blockState.getBlock();
                    Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.block.FluidDrainable");
                    ItemStack fluid = ((BucketPickup)block).pickupBlock(user, (LevelAccessor)world, pos, blockState);
                    if (!Intrinsics.areEqual((Object)fluid.getItem(), (Object)Fluids.EMPTY.getBucket())) {
                        user.awardStat(Stats.ITEM_USED.get((Object)this));
                        user.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
                        if (!world.isClientSide) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)user, new ItemStack((ItemLike)ItemCompendium.INSTANCE.getVOID_BUCKET()));
                        }
                        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)itemStack);
                        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                        return interactionResultHolder;
                    }
                }
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                blockHitResult = interactionResultHolder;
                if (interactionResultHolder != null) break block8;
            }
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)itemStack);
            blockHitResult = interactionResultHolder;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        }
        return blockHitResult;
    }

    private final boolean fakeInteraction(Level world, BlockPos pos, BlockHitResult blockHitResult) {
        Player fakePlayer = world instanceof ServerLevel ? (Player)FakePlayer.get((ServerLevel)((ServerLevel)world)) : (Player)new FakeClientPlayerEntity(world);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BUCKET));
        BlockState blockState = world.getBlockState(pos);
        blockState.useWithoutItem(world, fakePlayer, blockHitResult);
        ItemStack resultStack = fakePlayer.getItemInHand(InteractionHand.MAIN_HAND);
        Item resultItem = resultStack.getItem();
        return !Intrinsics.areEqual((Object)resultItem, (Object)Items.BUCKET);
    }
}

