/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lio/github/lucaargolo/kibe/item/SleepingBag;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "direction", "", "isSleepingBagObstructed", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "Lcom/mojang/datafixers/util/Either;", "Lnet/minecraft/world/entity/player/Player$BedSleepingProblem;", "Lnet/minecraft/util/Unit;", "customTrySleep", "(Lnet/minecraft/world/entity/player/Player;)Lcom/mojang/datafixers/util/Either;", "Companion", "kibe"})
public final class SleepingBag
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Player> playersSleeping = new ArrayList();

    public SleepingBag(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!world.isClientSide) {
            this.customTrySleep(player).ifLeft(arg_0 -> SleepingBag.use$lambda$1(arg_0 -> SleepingBag.use$lambda$0(player, arg_0), arg_0));
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)player.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    private final boolean isSleepingBagObstructed(Level world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.above();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        BlockPos blockPos2 = blockPos;
        return world.getBlockState(blockPos2).isSuffocating((BlockGetter)world, blockPos2) || world.getBlockState(blockPos2.relative(direction.getOpposite())).isSuffocating((BlockGetter)world, blockPos2.relative(direction.getOpposite()));
    }

    private final Either<Player.BedSleepingProblem, net.minecraft.util.Unit> customTrySleep(Player player) {
        BlockPos sleepingPos;
        block9: {
            block8: {
                HitResult rayTraceContext;
                HitResult $this$customTrySleep_u24lambda_u240 = rayTraceContext = player.pick(4.5, 1.0f, false);
                boolean bl = false;
                sleepingPos = $this$customTrySleep_u24lambda_u240.getType() == HitResult.Type.BLOCK ? BlockPos.containing((Position)((Position)$this$customTrySleep_u24lambda_u240.getLocation())) : (player.onGround() ? player.blockPosition() : null);
                if (player.isSleeping() || !player.isAlive()) {
                    Either either = Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
                    Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
                    return either;
                }
                if (!player.level().dimensionType().hasSkyLight()) {
                    Either either = Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
                    Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
                    return either;
                }
                if (player.level().isDay()) {
                    Either either = Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
                    Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
                    return either;
                }
                if (sleepingPos == null) break block8;
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getWorld(...)");
                Direction direction = player.getDirection();
                Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getHorizontalFacing(...)");
                if (!this.isSleepingBagObstructed(level, sleepingPos, direction)) break block9;
            }
            Either either = Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
            return either;
        }
        if (!player.isCreative()) {
            Vec3 vec3d = player.position();
            List list = player.level().getEntitiesOfClass(Monster.class, new AABB(vec3d.x() - 8.0, vec3d.y() - 5.0, vec3d.z() - 8.0, vec3d.x() + 8.0, vec3d.y() + 5.0, vec3d.z() + 8.0), arg_0 -> SleepingBag.customTrySleep$lambda$2(arg_0 -> SleepingBag.customTrySleep$lambda$1(player, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)list);
            if (!((Collection)list).isEmpty()) {
                Either either = Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
                return either;
            }
        }
        playersSleeping.add(player);
        player.startSleeping(sleepingPos);
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
        ((ServerLevel)level).updateSleepingPlayerList();
        Either either = Either.right((Object)net.minecraft.util.Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
        return either;
    }

    private static final Unit use$lambda$0(Player $player, Player.BedSleepingProblem sleepFailureReason) {
        if (sleepFailureReason != null) {
            $player.displayClientMessage(sleepFailureReason.getMessage(), true);
        }
        return Unit.INSTANCE;
    }

    private static final void use$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean customTrySleep$lambda$1(Player $player, Monster hostileEntity) {
        Intrinsics.checkNotNullParameter((Object)hostileEntity, (String)"hostileEntity");
        return hostileEntity.isPreventingPlayerRest($player);
    }

    private static final boolean customTrySleep$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/lucaargolo/kibe/item/SleepingBag$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/world/entity/player/Player;", "playersSleeping", "Ljava/util/List;", "getPlayersSleeping", "()Ljava/util/List;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Player> getPlayersSleeping() {
            return playersSleeping;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

