/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.effect.EffectCompendium;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0003()*B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J9\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010&\u001a\u00020\b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030$H&\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006+"}, d2={"Lio/github/lucaargolo/kibe/item/Lasso;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "hasGlint", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "useOnEntity", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "useOnBlock", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/item/Item$TooltipContext;", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "type", "", "appendTooltip", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/world/entity/Entity;", "addToEntity", "(Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/world/entity/EntityType;", "entityType", "canStoreEntity", "(Lnet/minecraft/world/entity/EntityType;)Z", "GoldenLasso", "CursedLasso", "DiamondLasso", "kibe"})
public abstract class Lasso
extends Item {
    public Lasso(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.has(DataComponents.ENTITY_DATA);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player user, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!stack.has(DataComponents.ENTITY_DATA) && entity instanceof Mob) {
            EntityType entityType = ((Mob)entity).getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
            if (this.canStoreEntity(entityType) && !KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getLassoDenyList().contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((Mob)entity).getType()).toString())) {
                if (!user.level().isClientSide) {
                    if (((Mob)entity).isLeashed()) {
                        ((Mob)entity).dropLeash(true, true);
                    }
                    entity.fallDistance = 0.0f;
                    CompoundTag tag = new CompoundTag();
                    entity.saveAsPassenger(tag);
                    stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CustomData customData = (CustomData)context.getItemInHand().get(DataComponents.ENTITY_DATA);
        if (customData != null) {
            CustomData tagComponent = customData;
            boolean bl = false;
            CompoundTag tag = tagComponent.copyTag();
            if (context.getLevel() instanceof ServerLevel) {
                Entity newEntity;
                BlockPos targetPos;
                BlockPos pos = context.getClickedPos();
                Direction direction = context.getClickedFace();
                switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1: {
                        BlockPos blockPos = pos.below(2);
                        break;
                    }
                    case 2: {
                        BlockPos blockPos = pos.above();
                        break;
                    }
                    case 3: {
                        BlockPos blockPos = pos.east();
                        break;
                    }
                    case 4: {
                        BlockPos blockPos = pos.north();
                        break;
                    }
                    case 5: {
                        BlockPos blockPos = pos.west();
                        break;
                    }
                    case 6: {
                        BlockPos blockPos = pos.south();
                        break;
                    }
                    default: {
                        BlockPos blockPos = targetPos = pos;
                    }
                }
                if (tag.contains("APX")) {
                    tag.putInt("APX", targetPos.getX());
                    tag.putInt("APY", targetPos.getY());
                    tag.putInt("APZ", targetPos.getZ());
                }
                if ((newEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)context.getLevel(), arg_0 -> Lasso.useOnBlock$lambda$0$0(targetPos, context, arg_0))) != null) {
                    this.addToEntity(newEntity);
                    context.getItemInHand().remove(DataComponents.ENTITY_DATA);
                }
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOnBlock(...)");
        return interactionResult;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @Nullable TooltipFlag type) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.appendHoverText(stack, context, tooltip, type);
        Object object = (CustomData)stack.get(DataComponents.ENTITY_DATA);
        if (object == null || (object = object.copyTag()) == null || (object = object.getString("id")) == null || (object = StringsKt.replace$default((String)object, (String)":", (String)".", (boolean)false, (int)4, null)) == null) {
            return;
        }
        Object entity = object;
        MutableComponent mutableComponent = Component.translatable((String)"tooltip.kibe.stored").append((Component)Component.translatable((String)("entity." + (String)entity)));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
        tooltip.add((Component)mutableComponent);
    }

    public void addToEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    public abstract boolean canStoreEntity(@NotNull EntityType<?> var1);

    private static final Entity useOnBlock$lambda$0$0(BlockPos $targetPos, UseOnContext $context, Entity it) {
        Entity entity;
        it.moveTo((double)$targetPos.getX() + 0.5, (double)$targetPos.getY() + 0.0, (double)$targetPos.getZ() + 0.5, it.getYRot(), it.getXRot());
        Level level = $context.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
        if (!((ServerLevel)level).addWithUUID(it)) {
            Player player = $context.getPlayer();
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.kibe.lasso.cannot_spawn"), true);
            }
            entity = null;
        } else {
            entity = it;
        }
        return entity;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/github/lucaargolo/kibe/item/Lasso$CursedLasso;", "Lio/github/lucaargolo/kibe/item/Lasso;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "", "addToEntity", "(Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/world/entity/EntityType;", "entityType", "", "canStoreEntity", "(Lnet/minecraft/world/entity/EntityType;)Z", "kibe"})
    public static final class CursedLasso
    extends Lasso {
        public CursedLasso(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(settings);
        }

        @Override
        public void addToEntity(@NotNull Entity entity) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
                if (livingEntity == null) break block0;
                livingEntity.addEffect(new MobEffectInstance((Holder)EffectCompendium.INSTANCE.getCURSED(), 999999, 0));
            }
        }

        @Override
        public boolean canStoreEntity(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            return entityType.getCategory() == MobCategory.MONSTER && !Intrinsics.areEqual(entityType, (Object)EntityType.ENDER_DRAGON) && !Intrinsics.areEqual(entityType, (Object)EntityType.WITHER);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/github/lucaargolo/kibe/item/Lasso$DiamondLasso;", "Lio/github/lucaargolo/kibe/item/Lasso;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/entity/EntityType;", "entityType", "", "canStoreEntity", "(Lnet/minecraft/world/entity/EntityType;)Z", "kibe"})
    public static final class DiamondLasso
    extends Lasso {
        public DiamondLasso(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(settings);
        }

        @Override
        public boolean canStoreEntity(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            return Intrinsics.areEqual(entityType, (Object)EntityType.VILLAGER) || entityType.getCategory() != MobCategory.MISC && !Intrinsics.areEqual(entityType, (Object)EntityType.ENDER_DRAGON) && !Intrinsics.areEqual(entityType, (Object)EntityType.WITHER);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/github/lucaargolo/kibe/item/Lasso$GoldenLasso;", "Lio/github/lucaargolo/kibe/item/Lasso;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/entity/EntityType;", "entityType", "", "canStoreEntity", "(Lnet/minecraft/world/entity/EntityType;)Z", "kibe"})
    public static final class GoldenLasso
    extends Lasso {
        public GoldenLasso(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(settings);
        }

        @Override
        public boolean canStoreEntity(@NotNull EntityType<?> entityType) {
            Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
            return entityType.getCategory() != MobCategory.MONSTER && entityType.getCategory() != MobCategory.MISC;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

