/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.fluid.miscellaneous;

import io.github.lucaargolo.kibe.block.BlockCompendium;
import io.github.lucaargolo.kibe.fluid.FluidCompendium;
import io.github.lucaargolo.kibe.fluid.miscellaneous.ModdedFluid;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid;", "Lio/github/lucaargolo/kibe/fluid/miscellaneous/ModdedFluid;", "<init>", "()V", "Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Still;", "getStill", "()Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Still;", "Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Flowing;", "getFlowing", "()Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Flowing;", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "Lnet/minecraft/world/level/block/state/BlockState;", "toBlockState", "(Lnet/minecraft/world/level/material/FluidState;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/neoforged/neoforge/fluids/FluidType;", "getFluidType", "()Lnet/neoforged/neoforge/fluids/FluidType;", "Lnet/minecraft/world/item/Item;", "getBucketItem", "()Lnet/minecraft/world/item/Item;", "Flowing", "Still", "kibe"})
public abstract class LiquidXpFluid
extends ModdedFluid {
    @NotNull
    public Still getStill() {
        return FluidCompendium.INSTANCE.getLIQUID_XP();
    }

    @NotNull
    public Flowing getFlowing() {
        return FluidCompendium.INSTANCE.getLIQUID_XP_FLOWING();
    }

    @Nullable
    protected BlockState createLegacyBlock(@NotNull FluidState fluidState) {
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        LiquidBlock liquidBlock = BlockCompendium.INSTANCE.getFLUID_BLOCKS().get((Object)this.getStill());
        return liquidBlock != null && (liquidBlock = liquidBlock.defaultBlockState()) != null ? (BlockState)liquidBlock.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(FlowingFluid.getLegacyLevel((FluidState)fluidState))) : null;
    }

    @NotNull
    public FluidType getFluidType() {
        FluidType fluidType = FluidCompendium.INSTANCE.getLIQUID_XP_TYPE();
        Intrinsics.checkNotNullExpressionValue((Object)fluidType, (String)"<get-LIQUID_XP_TYPE>(...)");
        return fluidType;
    }

    @Nullable
    public Item getBucket() {
        return (Item)ItemCompendium.INSTANCE.getFLUID_BUCKETS().get((Object)this.getStill());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\b2\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Flowing;", "Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid;", "<init>", "()V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/material/Fluid;", "Lnet/minecraft/world/level/material/FluidState;", "builder", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "fluidState", "", "getLevel", "(Lnet/minecraft/world/level/material/FluidState;)I", "", "isStill", "(Lnet/minecraft/world/level/material/FluidState;)Z", "kibe"})
    public static final class Flowing
    extends LiquidXpFluid {
        protected void createFluidStateDefinition(@NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            super.createFluidStateDefinition(builder);
            Property[] propertyArray = new Property[]{FlowingFluid.LEVEL};
            builder.add(propertyArray);
        }

        public int getAmount(@NotNull FluidState fluidState) {
            Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
            Comparable comparable = fluidState.getValue((Property)FlowingFluid.LEVEL);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"get(...)");
            return ((Number)((Object)comparable)).intValue();
        }

        public boolean isSource(@Nullable FluidState fluidState) {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid$Still;", "Lio/github/lucaargolo/kibe/fluid/miscellaneous/LiquidXpFluid;", "<init>", "()V", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "", "getLevel", "(Lnet/minecraft/world/level/material/FluidState;)I", "", "isStill", "(Lnet/minecraft/world/level/material/FluidState;)Z", "kibe"})
    public static final class Still
    extends LiquidXpFluid {
        public int getAmount(@Nullable FluidState fluidState) {
            return 8;
        }

        public boolean isSource(@Nullable FluidState fluidState) {
            return true;
        }
    }
}

