/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.entity;

import io.github.lucaargolo.kibe.entity.EntityCompendium;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nB)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001e\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/github/lucaargolo/kibe/entity/ThrownTorchEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "Lnet/minecraft/world/entity/EntityType;", "entityType", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/world/entity/LivingEntity;", "owner", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "", "x", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "Lnet/minecraft/world/item/Item;", "getDefaultItem", "()Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/phys/EntityHitResult;", "entityHitResult", "", "onEntityHit", "(Lnet/minecraft/world/phys/EntityHitResult;)V", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "onBlockHit", "(Lnet/minecraft/world/phys/BlockHitResult;)V", "Lnet/minecraft/world/phys/HitResult;", "hitResult", "onCollision", "(Lnet/minecraft/world/phys/HitResult;)V", "kibe"})
public final class ThrownTorchEntity
extends ThrowableItemProjectile {
    public ThrownTorchEntity(@NotNull EntityType<ThrownTorchEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
    }

    public ThrownTorchEntity(@NotNull Level world, @NotNull LivingEntity owner) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(EntityCompendium.INSTANCE.getTHROWN_TORCH(), owner, world);
    }

    public ThrownTorchEntity(@NotNull Level world, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(EntityCompendium.INSTANCE.getTHROWN_TORCH(), x, y, z, world);
    }

    @NotNull
    protected Item getDefaultItem() {
        Item item = Items.TORCH;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"TORCH");
        return item;
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        Intrinsics.checkNotNullParameter((Object)entityHitResult, (String)"entityHitResult");
        Vec3 finalPos = entityHitResult.getLocation();
        Containers.dropItemStack((Level)this.level(), (double)finalPos.x, (double)finalPos.y, (double)finalPos.z, (ItemStack)new ItemStack((ItemLike)this.getItem().getItem()));
        super.onHitEntity(entityHitResult);
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        Entity entity = this.getOwner();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player playerEntity = player;
        BlockPos hitPos = blockHitResult.getBlockPos();
        Direction hitSide = blockHitResult.getDirection();
        BlockPos finalPos = hitPos.offset(hitSide.getNormal());
        Item item = this.getItem().getItem();
        BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
        if (!(blockItem != null && (blockItem = blockItem.place(new BlockPlaceContext(playerEntity, InteractionHand.MAIN_HAND, this.getItem(), blockHitResult))) != null ? blockItem.consumesAction() : false)) {
            Containers.dropItemStack((Level)this.level(), (double)((double)finalPos.getX() + 0.0), (double)((double)finalPos.getY() + 0.0), (double)((double)finalPos.getZ() + 0.0), (ItemStack)new ItemStack((ItemLike)this.getItem().getItem()));
        }
        super.onHitBlock(blockHitResult);
    }

    protected void onHit(@Nullable HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }
}

