/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.model;

import io.github.lucaargolo.kibe.blockentity.DrawbridgeBlockEntity;
import io.github.lucaargolo.kibe.utils.ModIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\r\u001a\u00020\f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ=\u0010(\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J-\u0010,\u001a\u00020\f2\u0006\u0010+\u001a\u00020*2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b,\u0010-JE\u00102\u001a\u00020\f*\u00020\u00022\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010'\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0/H\u0002\u00a2\u0006\u0004\b2\u00103J3\u00108\u001a\b\u0012\u0004\u0012\u000200072\b\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u00105\u001a\u0004\u0018\u0001042\b\u00106\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b:\u0010\u001cJ\u000f\u0010;\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b;\u0010\u001cJ\u000f\u0010<\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b<\u0010\u001cJ\u000f\u0010=\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b=\u0010\u001cJ\u000f\u0010?\u001a\u00020>H\u0016\u00a2\u0006\u0004\b?\u0010@J\u000f\u0010B\u001a\u00020AH\u0016\u00a2\u0006\u0004\bB\u0010CR\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0011078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u001d\u0010F\u001a\b\u0012\u0004\u0012\u00020\u0012078\u0006\u00a2\u0006\f\n\u0004\bF\u0010E\u001a\u0004\bG\u0010HR\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u0007078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010ER\u001d\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0002078\u0006\u00a2\u0006\f\n\u0004\bJ\u0010E\u001a\u0004\bK\u0010HR\"\u0010L\u001a\u00020A8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010C\"\u0004\bO\u0010P\u00a8\u0006Q"}, d2={"Lio/github/lucaargolo/kibe/client/model/DrawbridgeCustomModel;", "Lnet/minecraft/client/resources/model/UnbakedModel;", "Lnet/minecraft/client/resources/model/BakedModel;", "Lnet/fabricmc/fabric/api/renderer/v1/model/FabricBakedModel;", "<init>", "()V", "", "Lnet/minecraft/resources/ResourceLocation;", "getModelDependencies", "()Ljava/util/Collection;", "Ljava/util/function/Function;", "modelLoader", "", "setParents", "(Ljava/util/function/Function;)V", "Lnet/minecraft/client/resources/model/ModelBaker;", "baker", "Lnet/minecraft/client/resources/model/Material;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "textureGetter", "Lnet/minecraft/client/resources/model/ModelState;", "rotationContainer", "bake", "(Lnet/minecraft/client/resources/model/ModelBaker;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;)Lnet/minecraft/client/resources/model/BakedModel;", "getParticleSprite", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "", "isVanillaAdapter", "()Z", "Lnet/minecraft/world/level/BlockAndTintGetter;", "world", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "pos", "Ljava/util/function/Supplier;", "Lnet/minecraft/util/RandomSource;", "randomSupplier", "Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;", "context", "emitBlockQuads", "(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Ljava/util/function/Supplier;Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "emitItemQuads", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/function/Supplier;Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;)V", "randSupplier", "Lkotlin/Function1;", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "shouldEmit", "emitFromVanilla", "(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/level/block/state/BlockState;Lnet/fabricmc/fabric/api/renderer/v1/render/RenderContext;Ljava/util/function/Supplier;Lkotlin/jvm/functions/Function1;)V", "Lnet/minecraft/core/Direction;", "face", "random", "", "getQuads", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/util/RandomSource;)Ljava/util/List;", "useAmbientOcclusion", "hasDepth", "isSideLit", "isBuiltin", "Lnet/minecraft/client/renderer/block/model/ItemOverrides;", "getOverrides", "()Lnet/minecraft/client/renderer/block/model/ItemOverrides;", "Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "getTransformation", "()Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "spriteIdList", "Ljava/util/List;", "spriteList", "getSpriteList", "()Ljava/util/List;", "modelIdList", "modelList", "getModelList", "modelTransformation", "Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "getModelTransformation", "setModelTransformation", "(Lnet/minecraft/client/renderer/block/model/ItemTransforms;)V", "kibe"})
@SourceDebugExtension(value={"SMAP\nDrawbridgeCustomModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawbridgeCustomModel.kt\nio/github/lucaargolo/kibe/client/model/DrawbridgeCustomModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1878#2,3:136\n1869#2:139\n1869#2,2:140\n1870#2:142\n1869#2,2:143\n*S KotlinDebug\n*F\n+ 1 DrawbridgeCustomModel.kt\nio/github/lucaargolo/kibe/client/model/DrawbridgeCustomModel\n*L\n59#1:136,3\n109#1:139\n110#1:140,2\n109#1:142\n117#1:143,2\n*E\n"})
public final class DrawbridgeCustomModel
implements UnbakedModel,
BakedModel,
FabricBakedModel {
    @NotNull
    private final List<Material> spriteIdList;
    @NotNull
    private final List<TextureAtlasSprite> spriteList;
    @NotNull
    private final List<ResourceLocation> modelIdList;
    @NotNull
    private final List<BakedModel> modelList;
    public ItemTransforms modelTransformation;

    public DrawbridgeCustomModel() {
        Object[] objectArray = new Material[]{new Material(InventoryMenu.BLOCK_ATLAS, ModIdentifier.INSTANCE.of("block/drawbridge_front")), new Material(InventoryMenu.BLOCK_ATLAS, ModIdentifier.INSTANCE.of("block/drawbridge_side")), new Material(InventoryMenu.BLOCK_ATLAS, ModIdentifier.INSTANCE.of("block/drawbridge_back"))};
        this.spriteIdList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.spriteList = new ArrayList();
        objectArray = new ResourceLocation[]{ModIdentifier.INSTANCE.of("block/drawbridge")};
        this.modelIdList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.modelList = new ArrayList();
    }

    @NotNull
    public final List<TextureAtlasSprite> getSpriteList() {
        return this.spriteList;
    }

    @NotNull
    public final List<BakedModel> getModelList() {
        return this.modelList;
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return CollectionsKt.emptyList();
    }

    public void resolveParents(@Nullable Function<ResourceLocation, UnbakedModel> modelLoader) {
    }

    @NotNull
    public final ItemTransforms getModelTransformation() {
        ItemTransforms itemTransforms = this.modelTransformation;
        if (itemTransforms != null) {
            return itemTransforms;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"modelTransformation");
        return null;
    }

    public final void setModelTransformation(@NotNull ItemTransforms itemTransforms) {
        Intrinsics.checkNotNullParameter((Object)itemTransforms, (String)"<set-?>");
        this.modelTransformation = itemTransforms;
    }

    @NotNull
    public BakedModel bake(@NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> textureGetter, @NotNull ModelState rotationContainer) {
        Intrinsics.checkNotNullParameter((Object)baker, (String)"baker");
        Intrinsics.checkNotNullParameter(textureGetter, (String)"textureGetter");
        Intrinsics.checkNotNullParameter((Object)rotationContainer, (String)"rotationContainer");
        UnbakedModel model = baker.getModel(this.modelIdList.get(0));
        BakedModel bakedModel = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X0_Y0);
        Intrinsics.checkNotNull((Object)bakedModel);
        this.modelList.add(bakedModel);
        BakedModel bakedModel2 = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X0_Y180);
        Intrinsics.checkNotNull((Object)bakedModel2);
        this.modelList.add(bakedModel2);
        BakedModel bakedModel3 = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X0_Y270);
        Intrinsics.checkNotNull((Object)bakedModel3);
        this.modelList.add(bakedModel3);
        BakedModel bakedModel4 = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X0_Y90);
        Intrinsics.checkNotNull((Object)bakedModel4);
        this.modelList.add(bakedModel4);
        BakedModel bakedModel5 = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X270_Y0);
        Intrinsics.checkNotNull((Object)bakedModel5);
        this.modelList.add(bakedModel5);
        BakedModel bakedModel6 = model.bake(baker, textureGetter, (ModelState)BlockModelRotation.X90_Y0);
        Intrinsics.checkNotNull((Object)bakedModel6);
        this.modelList.add(bakedModel6);
        ItemTransforms itemTransforms = this.modelList.get(0).getTransforms();
        Intrinsics.checkNotNullExpressionValue((Object)itemTransforms, (String)"getTransformation(...)");
        this.setModelTransformation(itemTransforms);
        Iterable $this$forEachIndexed$iv = this.spriteIdList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Material spriteIdentifier = (Material)item$iv;
            boolean bl = false;
            TextureAtlasSprite textureAtlasSprite = textureGetter.apply(spriteIdentifier);
            Intrinsics.checkNotNullExpressionValue((Object)textureAtlasSprite, (String)"apply(...)");
            this.spriteList.add(textureAtlasSprite);
        }
        return this;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.spriteList.get(0);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(@NotNull BlockAndTintGetter world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Supplier<RandomSource> randomSupplier, @NotNull RenderContext context) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(randomSupplier, (String)"randomSupplier");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        DrawbridgeBlockEntity drawbridgeBlockEntity = blockEntity instanceof DrawbridgeBlockEntity ? (DrawbridgeBlockEntity)blockEntity : null;
        if (drawbridgeBlockEntity != null) {
            DrawbridgeBlockEntity blockEntity2 = drawbridgeBlockEntity;
            boolean bl = false;
            Item item = ((ItemStack)blockEntity2.getInventory().get(1)).getItem();
            BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
            if (blockItem != null && (blockItem = blockItem.getBlock()) != null && (blockItem = blockItem.defaultBlockState()) != null) {
                BlockItem coverState = blockItem;
                BakedModel model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel((BlockState)coverState);
                if (!Intrinsics.areEqual((Object)model, (Object)this)) {
                    if (model instanceof FabricBakedModel) {
                        ((FabricBakedModel)model).emitBlockQuads(world, state, pos, randomSupplier, context);
                    }
                    Intrinsics.checkNotNull((Object)model);
                    this.emitFromVanilla(model, state, context, randomSupplier, (Function1<? super BakedQuad, Boolean>)((Function1)DrawbridgeCustomModel::emitBlockQuads$lambda$0$0));
                    context.pushTransform(arg_0 -> DrawbridgeCustomModel.emitBlockQuads$lambda$0$1((BlockState)coverState, world, pos, arg_0));
                    this.emitFromVanilla(model, state, context, randomSupplier, (Function1<? super BakedQuad, Boolean>)((Function1)DrawbridgeCustomModel::emitBlockQuads$lambda$0$2));
                    context.popTransform();
                    return;
                }
            }
        }
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                BakedModel bakedModel = this.modelList.get(0);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
                break;
            }
            case 2: {
                BakedModel bakedModel = this.modelList.get(1);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
                break;
            }
            case 3: {
                BakedModel bakedModel = this.modelList.get(2);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
                break;
            }
            case 4: {
                BakedModel bakedModel = this.modelList.get(3);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
                break;
            }
            case 5: {
                BakedModel bakedModel = this.modelList.get(4);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
                break;
            }
            case 6: {
                BakedModel bakedModel = this.modelList.get(5);
                Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
                ((FabricBakedModel)bakedModel).emitBlockQuads(world, state, pos, randomSupplier, context);
            }
        }
    }

    public void emitItemQuads(@NotNull ItemStack stack, @NotNull Supplier<RandomSource> randomSupplier, @NotNull RenderContext context) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(randomSupplier, (String)"randomSupplier");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BakedModel bakedModel = this.modelList.get(4);
        Intrinsics.checkNotNull((Object)bakedModel, (String)"null cannot be cast to non-null type net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel");
        ((FabricBakedModel)bakedModel).emitItemQuads(stack, randomSupplier, context);
    }

    private final void emitFromVanilla(BakedModel $this$emitFromVanilla, BlockState state, RenderContext context, Supplier<RandomSource> randSupplier, Function1<? super BakedQuad, Boolean> shouldEmit) {
        QuadEmitter emitter = context.getEmitter();
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction dir = (Direction)element$iv;
            boolean bl = false;
            List list = $this$emitFromVanilla.getQuads(state, dir, randSupplier.get());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BakedQuad q = (BakedQuad)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)q);
                if (!((Boolean)shouldEmit.invoke((Object)q)).booleanValue()) continue;
                emitter.fromVanilla(q.getVertices(), 0);
                emitter.emit();
            }
        }
        List list = $this$emitFromVanilla.getQuads(state, null, randSupplier.get());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BakedQuad q = (BakedQuad)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)q);
            if (!((Boolean)shouldEmit.invoke((Object)q)).booleanValue()) continue;
            emitter.fromVanilla(q.getVertices(), 0);
            emitter.emit();
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction face, @Nullable RandomSource random) {
        return new ArrayList();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        ItemOverrides itemOverrides = ItemOverrides.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemOverrides, (String)"EMPTY");
        return itemOverrides;
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.getModelTransformation();
    }

    private static final boolean emitBlockQuads$lambda$0$0(BakedQuad quad) {
        Intrinsics.checkNotNullParameter((Object)quad, (String)"quad");
        return !quad.isTinted();
    }

    private static final boolean emitBlockQuads$lambda$0$1(BlockState $coverState, BlockAndTintGetter $world, BlockPos $pos, MutableQuadView q) {
        Object object = ColorProviderRegistry.BLOCK.get((Object)$coverState.getBlock());
        Intrinsics.checkNotNull((Object)object);
        int rawColor = ((BlockColor)object).getColor($coverState, $world, $pos, 0);
        int color = 0xFF000000 | rawColor;
        q.color(color, color, color, color);
        return true;
    }

    private static final boolean emitBlockQuads$lambda$0$2(BakedQuad quad) {
        Intrinsics.checkNotNullParameter((Object)quad, (String)"quad");
        return quad.isTinted();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

