/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lucaargolo.kibe.client.KibeModClient;
import io.github.lucaargolo.kibe.item.Glider;
import io.github.lucaargolo.kibe.utils.ModIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ?\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001e\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010!\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001b\u001a\u0004\b \u0010\u001d\u00a8\u0006\""}, d2={"Lio/github/lucaargolo/kibe/client/item/GliderDynamicRenderer;", "Lnet/fabricmc/fabric/api/client/rendering/v1/BuiltinItemRendererRegistry$DynamicItemRenderer;", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "location", "Ljava/io/Reader;", "getReaderForResource", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/io/Reader;", "Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "loadTransformFromJson", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/ItemDisplayContext;", "mode", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrixStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumerProvider", "", "lightmap", "overlay", "", "render", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "deployedTransform$delegate", "Lkotlin/Lazy;", "getDeployedTransform", "()Lnet/minecraft/client/renderer/block/model/ItemTransforms;", "deployedTransform", "itemTransform$delegate", "getItemTransform", "itemTransform", "kibe"})
@SourceDebugExtension(value={"SMAP\nGliderDynamicRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GliderDynamicRenderer.kt\nio/github/lucaargolo/kibe/client/item/GliderDynamicRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1869#2,2:97\n1869#2,2:99\n1869#2,2:101\n*S KotlinDebug\n*F\n+ 1 GliderDynamicRenderer.kt\nio/github/lucaargolo/kibe/client/item/GliderDynamicRenderer\n*L\n75#1:97,2\n82#1:99,2\n89#1:101,2\n*E\n"})
public final class GliderDynamicRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    @NotNull
    private final Lazy deployedTransform$delegate = LazyKt.lazy(() -> GliderDynamicRenderer.deployedTransform_delegate$lambda$0(this));
    @NotNull
    private final Lazy itemTransform$delegate = LazyKt.lazy(() -> GliderDynamicRenderer.itemTransform_delegate$lambda$0(this));

    private final Reader getReaderForResource(ResourceLocation location) throws IOException, NoSuchElementException {
        ResourceLocation file = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(location.getPath() + ".json"));
        Object t = Minecraft.getInstance().getResourceManager().getResource(file).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        Resource resource = (Resource)t;
        return new BufferedReader(new InputStreamReader(resource.open(), Charsets.UTF_8));
    }

    private final ItemTransforms loadTransformFromJson(ResourceLocation location) {
        ItemTransforms itemTransforms;
        try {
            itemTransforms = BlockModel.fromStream((Reader)this.getReaderForResource(location)).getTransforms();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            itemTransforms = null;
        }
        return itemTransforms;
    }

    private final ItemTransforms getDeployedTransform() {
        Lazy lazy = this.deployedTransform$delegate;
        return (ItemTransforms)lazy.getValue();
    }

    private final ItemTransforms getItemTransform() {
        Lazy lazy = this.itemTransform$delegate;
        return (ItemTransforms)lazy.getValue();
    }

    public void render(@NotNull ItemStack stack, @NotNull ItemDisplayContext mode, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, int lightmap, int overlay) {
        block10: {
            ResourceLocation itemId;
            VertexConsumer cutoutBuffer;
            boolean isEnabled;
            block9: {
                ResourceLocation gliderIdentifier;
                BakedModel gliderModel;
                Object object;
                boolean leftHanded;
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                Intrinsics.checkNotNullParameter((Object)vertexConsumerProvider, (String)"vertexConsumerProvider");
                isEnabled = Glider.Companion.isEnabled(stack);
                boolean isGui = mode == ItemDisplayContext.GUI || mode == ItemDisplayContext.FIXED;
                boolean force3d = mode == ItemDisplayContext.GROUND || mode == ItemDisplayContext.HEAD || mode == ItemDisplayContext.NONE;
                matrixStack.popPose();
                matrixStack.pushPose();
                boolean bl = leftHanded = mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || mode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                if (force3d || isEnabled && !isGui) {
                    ItemTransforms itemTransforms = this.getDeployedTransform();
                    if (itemTransforms != null && (itemTransforms = itemTransforms.getTransform(mode)) != null) {
                        itemTransforms.apply(leftHanded, matrixStack);
                    }
                } else {
                    ItemTransforms itemTransforms = this.getItemTransform();
                    if (itemTransforms != null && (itemTransforms = itemTransforms.getTransform(mode)) != null) {
                        itemTransforms.apply(leftHanded, matrixStack);
                    }
                }
                matrixStack.translate(-0.5, -0.5, -0.5);
                cutoutBuffer = vertexConsumerProvider.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
                itemId = resourceLocation;
                if (!force3d && (!isEnabled || isGui)) break block9;
                ResourceLocation handleIdentifier = ModIdentifier.INSTANCE.of("item/glider_handle");
                BakedModel handleModel = KibeModClient.INSTANCE.bakedModel(handleIdentifier);
                Object object2 = handleModel;
                if (object2 != null && (object2 = object2.getQuads(null, null, RandomSource.create())) != null) {
                    Iterable $this$forEach$iv = (Iterable)object2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BakedQuad q = (BakedQuad)element$iv;
                        boolean bl2 = false;
                        cutoutBuffer.putBulkData(matrixStack.last(), q, 1.0f, 1.0f, 1.0f, 1.0f, lightmap, overlay);
                    }
                }
                if ((object = (gliderModel = KibeModClient.INSTANCE.bakedModel(gliderIdentifier = ModIdentifier.INSTANCE.of("item/" + itemId.getPath() + "_active")))) == null || (object = object.getQuads(null, null, RandomSource.create())) == null) break block10;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BakedQuad q = (BakedQuad)element$iv;
                    boolean bl3 = false;
                    cutoutBuffer.putBulkData(matrixStack.last(), q, 1.0f, 1.0f, 1.0f, 1.0f, lightmap, overlay);
                }
                break block10;
            }
            ResourceLocation statusId = isEnabled ? ModIdentifier.INSTANCE.of("item/glider_active") : ModIdentifier.INSTANCE.of("item/" + itemId.getPath() + "_inactive");
            BakedModel invModel = KibeModClient.INSTANCE.bakedModel(statusId);
            Object object = invModel;
            if (object != null && (object = object.getQuads(null, null, RandomSource.create())) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BakedQuad q = (BakedQuad)element$iv;
                    boolean bl = false;
                    cutoutBuffer.putBulkData(matrixStack.last(), q, 1.0f, 1.0f, 1.0f, 1.0f, lightmap, overlay);
                }
            }
        }
    }

    private static final ItemTransforms deployedTransform_delegate$lambda$0(GliderDynamicRenderer this$0) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)"kibe:models/item/glider");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"of(...)");
        return this$0.loadTransformFromJson(resourceLocation);
    }

    private static final ItemTransforms itemTransform_delegate$lambda$0(GliderDynamicRenderer this$0) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)"minecraft:models/item/generated");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"of(...)");
        return this$0.loadTransformFromJson(resourceLocation);
    }
}

