/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lucaargolo.kibe.blockentity.VacuumHopperEntity;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJw\u0010%\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lio/github/lucaargolo/kibe/client/blockentity/VacuumHopperEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "arg", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lio/github/lucaargolo/kibe/blockentity/VacuumHopperEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "g", "Lorg/joml/Matrix4f;", "matrix4f", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vertexConsumer", "renderMiddlePart", "(FLorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V", "f", "h", "i", "j", "k", "l", "m", "red", "green", "blue", "renderVertices", "(Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/vertex/VertexConsumer;FFFFFFFFFFF)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "Ljava/util/Random;", "random", "Ljava/util/Random;", "kibe"})
public final class VacuumHopperEntityRenderer
implements BlockEntityRenderer<VacuumHopperEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context arg;
    @NotNull
    private final Random random;

    public VacuumHopperEntityRenderer(@NotNull BlockEntityRendererProvider.Context arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.arg = arg;
        this.random = new Random(31100L);
    }

    public void render(@NotNull VacuumHopperEntity blockEntity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (Intrinsics.areEqual((Object)blockEntity.getBlockState().getValue((Property)BlockStateProperties.ENABLED), (Object)true)) {
            matrices.pushPose();
            Matrix4f m = matrices.last().pose();
            Intrinsics.checkNotNull((Object)m);
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.endPortal());
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
            this.renderMiddlePart(0.15f, m, vertexConsumer);
            matrices.popPose();
        }
    }

    private final void renderMiddlePart(float g, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        float red = (this.random.nextFloat() * 0.5f + 0.1f) * g;
        float green = (this.random.nextFloat() * 0.5f + 0.4f) * g;
        float blue = (this.random.nextFloat() * 0.5f + 0.5f) * g;
        this.renderVertices(matrix4f, vertexConsumer, 0.02f, 0.98f, 0.02f, 0.98f, 0.98f, 0.98f, 0.98f, 0.98f, red, green, blue);
        this.renderVertices(matrix4f, vertexConsumer, 0.02f, 0.98f, 0.98f, 0.02f, 0.02f, 0.02f, 0.02f, 0.02f, red, green, blue);
        this.renderVertices(matrix4f, vertexConsumer, 0.98f, 0.98f, 0.98f, 0.02f, 0.02f, 0.98f, 0.98f, 0.02f, red, green, blue);
        this.renderVertices(matrix4f, vertexConsumer, 0.02f, 0.02f, 0.02f, 0.98f, 0.02f, 0.98f, 0.98f, 0.02f, red, green, blue);
        this.renderVertices(matrix4f, vertexConsumer, 0.02f, 0.98f, 0.02f, 0.02f, 0.02f, 0.02f, 0.98f, 0.98f, red, green, blue);
        this.renderVertices(matrix4f, vertexConsumer, 0.02f, 0.98f, 0.98f, 0.98f, 0.98f, 0.98f, 0.02f, 0.02f, red, green, blue);
    }

    private final void renderVertices(Matrix4f matrix4f, VertexConsumer vertexConsumer, float f, float g, float h, float i, float j, float k, float l, float m, float red, float green, float blue) {
        vertexConsumer.addVertex(matrix4f, f, h, j).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix4f, g, h, k).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix4f, g, i, l).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix4f, f, i, m).setColor(red, green, blue, 1.0f);
    }
}

