/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.lucaargolo.kibe.blockentity.RedstoneTimerEntity;
import io.github.lucaargolo.kibe.client.KibeModClient;
import io.github.lucaargolo.kibe.utils.ModIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lio/github/lucaargolo/kibe/client/blockentity/RedstoneTimerEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lio/github/lucaargolo/kibe/blockentity/RedstoneTimerEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "arg", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lio/github/lucaargolo/kibe/blockentity/RedstoneTimerEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/model/geom/ModelPart;", "selector", "renderSelector", "(Lnet/minecraft/client/model/geom/ModelPart;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nRedstoneTimerEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedstoneTimerEntityRenderer.kt\nio/github/lucaargolo/kibe/client/blockentity/RedstoneTimerEntityRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1869#2,2:144\n1869#2,2:146\n1869#2,2:148\n*S KotlinDebug\n*F\n+ 1 RedstoneTimerEntityRenderer.kt\nio/github/lucaargolo/kibe/client/blockentity/RedstoneTimerEntityRenderer\n*L\n62#1:144,2\n122#1:146,2\n26#1:148,2\n*E\n"})
public final class RedstoneTimerEntityRenderer
implements BlockEntityRenderer<RedstoneTimerEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context arg;
    @NotNull
    private static final List<ModelLayerLocation> selectorModelLayers = new ArrayList();

    public RedstoneTimerEntityRenderer(@NotNull BlockEntityRendererProvider.Context arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.arg = arg;
    }

    public void render(@NotNull RedstoneTimerEntity blockEntity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        block23: {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
            Material timerTexture = new Material(InventoryMenu.BLOCK_ATLAS, ModIdentifier.INSTANCE.of("block/redstone_timer_" + blockEntity.getCurrent() / 4));
            VertexConsumer timerConsumer = timerTexture.buffer(vertexConsumers, RedstoneTimerEntityRenderer::render$lambda$0);
            Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Quaternionf rot2;
                Direction direction = (Direction)element$iv;
                boolean bl = false;
                matrices.pushPose();
                matrices.translate(0.5, 0.5, 0.5);
                matrices.mulPose(switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1 -> Axis.YP.rotationDegrees(0.0f);
                    case 2 -> Axis.YP.rotationDegrees(180.0f);
                    case 3 -> Axis.YP.rotationDegrees(90.0f);
                    case 4 -> Axis.YP.rotationDegrees(270.0f);
                    case 5 -> Axis.ZP.rotationDegrees(90.0f);
                    case 6 -> Axis.ZP.rotationDegrees(270.0f);
                    default -> throw new NoWhenBranchMatchedException();
                });
                matrices.translate(-0.5, -0.5, -0.5);
                ModelPart selectorModel = this.arg.bakeLayer(selectorModelLayers.get(blockEntity.getLevel()));
                Intrinsics.checkNotNull((Object)selectorModel);
                this.renderSelector(selectorModel, matrices, vertexConsumers, light, overlay);
                matrices.popPose();
                matrices.pushPose();
                Vector3f vec = Direction.SOUTH.step();
                matrices.translate(0.5, 0.5, 0.5);
                Quaternionf rot1 = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1 -> Axis.YP.rotationDegrees(0.0f);
                    case 2 -> Axis.YP.rotationDegrees(180.0f);
                    case 3 -> Axis.YP.rotationDegrees(90.0f);
                    case 4 -> Axis.YP.rotationDegrees(270.0f);
                    case 5 -> Axis.XP.rotationDegrees(90.0f);
                    case 6 -> Axis.XP.rotationDegrees(270.0f);
                    default -> throw new NoWhenBranchMatchedException();
                };
                vec.rotate((Quaternionfc)rot1);
                matrices.mulPose(rot1);
                switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 5: {
                        Quaternionf quaternionf = Axis.ZP.rotationDegrees(90.0f);
                        break;
                    }
                    case 6: {
                        Quaternionf quaternionf = Axis.ZP.rotationDegrees(270.0f);
                        break;
                    }
                    default: {
                        Quaternionf quaternionf = rot2 = null;
                    }
                }
                if (rot2 != null) {
                    Quaternionf it;
                    boolean bl2 = false;
                    vec.rotate((Quaternionfc)it);
                    matrices.mulPose(it);
                }
                matrices.translate(-0.5, -0.5, -0.5);
                PoseStack.Pose entry = matrices.last();
                timerConsumer.addVertex(entry, 0.0625f, 0.0625f, 0.9375f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(entry, vec.x, vec.y, vec.z);
                timerConsumer.addVertex(entry, 0.9375f, 0.0625f, 0.9375f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(entry, vec.x, vec.y, vec.z);
                timerConsumer.addVertex(entry, 0.9375f, 0.9375f, 0.9375f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(entry, vec.x, vec.y, vec.z);
                timerConsumer.addVertex(entry, 0.0625f, 0.9375f, 0.9375f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(entry, vec.x, vec.y, vec.z);
                matrices.popPose();
            }
            ResourceLocation tankGlassIdentifier = ModIdentifier.INSTANCE.of("block/redstone_timer_structure");
            BakedModel tankGlassModel = KibeModClient.INSTANCE.bakedModel(tankGlassIdentifier);
            VertexConsumer cutoutBuffer = vertexConsumers.getBuffer(RenderType.cutout());
            Object object = tankGlassModel;
            if (object == null || (object = object.getQuads(null, null, RandomSource.create())) == null) break block23;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                BakedQuad q = (BakedQuad)element$iv;
                boolean bl = false;
                cutoutBuffer.putBulkData(matrices.last(), q, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
            }
        }
    }

    private final void renderSelector(ModelPart selector, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Material ironTexture = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)"block/iron_block"));
        VertexConsumer ironConsumer = ironTexture.buffer(vertexConsumers, RenderType::entitySolid);
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(0.0, -1.0, -1.0);
        matrices.mulPose(Axis.XP.rotationDegrees(-90.0f));
        matrices.translate(0.0, -1.0, 0.0);
        selector.render(matrices, ironConsumer, light, overlay);
    }

    private static final RenderType render$lambda$0(ResourceLocation texture) {
        return RenderType.entitySolid((ResourceLocation)texture);
    }

    static {
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 15);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int level = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            selectorModelLayers.add(new ModelLayerLocation(ModIdentifier.INSTANCE.of("redstone_timer"), "selector" + level));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/lucaargolo/kibe/client/blockentity/RedstoneTimerEntityRenderer$Companion;", "", "<init>", "()V", "", "level", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "setupSelectorModel", "(I)Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "selectorModelLayers", "Ljava/util/List;", "getSelectorModelLayers", "()Ljava/util/List;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ModelLayerLocation> getSelectorModelLayers() {
            return selectorModelLayers;
        }

        @NotNull
        public final LayerDefinition setupSelectorModel(int level) {
            int n;
            int offsetX;
            block4: {
                int n2;
                block5: {
                    block3: {
                        int n3;
                        block1: {
                            int n4;
                            block2: {
                                block0: {
                                    n4 = level;
                                    boolean bl = 0 <= n4 ? n4 < 5 : false;
                                    if (!bl) break block0;
                                    n3 = level * 2;
                                    break block1;
                                }
                                boolean bl = 5 <= n4 ? n4 < 9 : false;
                                if (!bl) break block2;
                                n3 = 8;
                                break block1;
                            }
                            n3 = (9 <= n4 ? n4 < 13 : false) ? 24 - level * 2 : ((13 <= n4 ? n4 < 16 : false) ? 0 : 0);
                        }
                        offsetX = n3;
                        n2 = level;
                        boolean bl = 0 <= n2 ? n2 < 5 : false;
                        if (!bl) break block3;
                        n = 0;
                        break block4;
                    }
                    boolean bl = 5 <= n2 ? n2 < 9 : false;
                    if (!bl) break block5;
                    n = (level - 4) * 2;
                    break block4;
                }
                n = (9 <= n2 ? n2 < 13 : false) ? 8 : ((13 <= n2 ? n2 < 16 : false) ? 32 - level * 2 : 0);
            }
            int offsetY = n;
            MeshDefinition lv = new MeshDefinition();
            PartDefinition lv2 = lv.getRoot();
            lv2.addOrReplaceChild("selector", CubeListBuilder.create().texOffs(3, 3).addBox(0.0f, 3.0f + (float)offsetX, 3.0f + (float)offsetY, 1.0f, 2.0f, 2.0f), PartPose.ZERO);
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)lv, (int)16, (int)16);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"of(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

