/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.blockentity;

import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u001f\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00142\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010*\u001a\u00020)2\b\u0010(\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0004\b*\u0010+J)\u0010-\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0004\b-\u0010.J+\u0010/\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\b\u0010,\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0004\b/\u0010.R(\u00101\u001a\b\u0012\u0004\u0012\u00020\u0018008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lio/github/lucaargolo/kibe/blockentity/WitherBuilderBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "readNbt", "", "size", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeStack", "(II)Lnet/minecraft/world/item/ItemStack;", "stack", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "clear", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getAvailableSlots", "(Lnet/minecraft/core/Direction;)[I", "dir", "canInsert", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canExtract", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "setInventory", "(Lnet/minecraft/core/NonNullList;)V", "kibe"})
@SourceDebugExtension(value={"SMAP\nWitherBuilderBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitherBuilderBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/WitherBuilderBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1740#2,3:74\n1563#2:78\n1634#2,3:79\n1573#2:82\n1604#2,4:83\n774#2:87\n865#2,2:88\n1563#2:90\n1634#2,3:91\n1#3:77\n*S KotlinDebug\n*F\n+ 1 WitherBuilderBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/WitherBuilderBlockEntity\n*L\n33#1:74,3\n55#1:78\n55#1:79,3\n56#1:82\n56#1:83,4\n57#1:87\n57#1:88,2\n58#1:90\n58#1:91,3\n*E\n"})
public final class WitherBuilderBlockEntity
extends BlockEntity
implements WorldlyContainer {
    @NotNull
    private NonNullList<ItemStack> inventory;

    public WitherBuilderBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getWITHER_BUILDER(), pos, state);
        NonNullList nonNullList = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(...)");
        this.inventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.inventory = nonNullList;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(tag, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.inventory;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.inventory.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.inventory), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"splitStack(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.inventory), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public boolean stillValid(@NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.level;
        if (level != null && (level = level.getBlockEntity(this.worldPosition)) != null) {
            Level it = level;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)((Object)this)) && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public int[] getSlotsForFace(@Nullable Direction side) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$mapIndexedTo$iv$iv;
        int n;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv = (Iterable)this.inventory;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ItemStack itemStack = (ItemStack)item$iv$iv;
            collection = destination$iv$iv;
            n = 0;
            collection.add(it.isEmpty() ? 0 : it.getCount());
        }
        Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int maxCount = (n2 != null ? n2 : 0) + 1;
        Iterable $this$mapIndexed$iv = (Iterable)this.inventory;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv2 = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void stack;
            void slot;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv$iv;
            int n3 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)((int)slot), (Object)stack));
        }
        List a = (List)destination$iv$iv;
        Iterable $this$filter$iv = a;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((ItemStack)it.getSecond()).isEmpty() || ((ItemStack)it.getSecond()).getCount() < maxCount)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List b = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = b;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            collection.add(((Number)it.getFirst()).intValue());
        }
        List c = (List)destination$iv$iv3;
        return CollectionsKt.toIntArray((Collection)c);
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction dir) {
        Item item;
        BlockItem blockItem;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return new IntRange(0, 3).contains(slot) ? ((blockItem = (item = stack.getItem()) instanceof BlockItem ? (BlockItem)item : null) != null && (blockItem = blockItem.getBlock()) != null && (blockItem = blockItem.builtInRegistryHolder()) != null ? blockItem.is(BlockTags.WITHER_SUMMON_BASE_BLOCKS) : false) : Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.WITHER_SKELETON_SKULL);
    }

    public boolean canTakeItemThroughFace(int slot, @Nullable ItemStack stack, @Nullable Direction dir) {
        return true;
    }
}

