/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.blockentity;

import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.data.state.ChunkLoaderState;
import io.github.lucaargolo.kibe.utils.SyncableBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 :2\u00020\u0001:\u0002;:B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0013\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0014R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010\u0018R4\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.03028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;", "Lio/github/lucaargolo/kibe/utils/SyncableBlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "readNbt", "writeClientNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "readClientNbt", "markDirty", "()V", "markDirtyAndSync", "", "checkForOwner", "Z", "getCheckForOwner", "()Z", "setCheckForOwner", "(Z)V", "", "ownerUUID", "Ljava/lang/String;", "getOwnerUUID", "()Ljava/lang/String;", "setOwnerUUID", "(Ljava/lang/String;)V", "Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$DisabledReason;", "disabledReason", "Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$DisabledReason;", "getDisabledReason", "()Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$DisabledReason;", "setDisabledReason", "(Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$DisabledReason;)V", "", "ownerLastSeen", "J", "", "delay", "I", "dirty", "", "Lkotlin/Pair;", "enabledChunks", "Ljava/util/List;", "getEnabledChunks", "()Ljava/util/List;", "setEnabledChunks", "(Ljava/util/List;)V", "Companion", "DisabledReason", "kibe"})
@SourceDebugExtension(value={"SMAP\nChunkLoaderBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoaderBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1869#2,2:174\n1869#2,2:176\n1#3:178\n*S KotlinDebug\n*F\n+ 1 ChunkLoaderBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity\n*L\n45#1:174,2\n64#1:176,2\n*E\n"})
public final class ChunkLoaderBlockEntity
extends SyncableBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean checkForOwner;
    @NotNull
    private String ownerUUID;
    @NotNull
    private DisabledReason disabledReason;
    private long ownerLastSeen;
    private int delay;
    private boolean dirty;
    @NotNull
    private List<Pair<Integer, Integer>> enabledChunks;

    public ChunkLoaderBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getCHUNK_LOADER(), pos, state);
        this.ownerUUID = "";
        this.disabledReason = DisabledReason.NONE;
        this.ownerLastSeen = System.currentTimeMillis();
        Object[] objectArray = new Pair[]{new Pair((Object)-1, (Object)-1), new Pair((Object)0, (Object)-1), new Pair((Object)1, (Object)-1), new Pair((Object)-1, (Object)0), new Pair((Object)0, (Object)0), new Pair((Object)1, (Object)0), new Pair((Object)-1, (Object)1), new Pair((Object)0, (Object)1), new Pair((Object)1, (Object)1)};
        this.enabledChunks = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final boolean getCheckForOwner() {
        return this.checkForOwner;
    }

    public final void setCheckForOwner(boolean bl) {
        this.checkForOwner = bl;
    }

    @NotNull
    public final String getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ownerUUID = string;
    }

    @NotNull
    public final DisabledReason getDisabledReason() {
        return this.disabledReason;
    }

    public final void setDisabledReason(@NotNull DisabledReason disabledReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)disabledReason), (String)"<set-?>");
        this.disabledReason = disabledReason;
    }

    @NotNull
    public final List<Pair<Integer, Integer>> getEnabledChunks() {
        return this.enabledChunks;
    }

    public final void setEnabledChunks(@NotNull List<Pair<Integer, Integer>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.enabledChunks = list;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        tag.putBoolean("checkForOwner", this.checkForOwner);
        tag.putString("ownerUUID", this.ownerUUID);
        tag.putLong("ownerLastSeen", this.ownerLastSeen);
        tag.putString("disabledReason", this.disabledReason.name());
        ListTag list = new ListTag();
        Iterable $this$forEach$iv = this.enabledChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            CompoundTag innerTag = new CompoundTag();
            innerTag.putInt("x", ((Number)it.getFirst()).intValue());
            innerTag.putInt("z", ((Number)it.getSecond()).intValue());
            list.add((Object)innerTag);
        }
        tag.put("enabledChunks", (Tag)list);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        block3: {
            ListTag list;
            DisabledReason disabledReason;
            ChunkLoaderBlockEntity chunkLoaderBlockEntity;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
            super.loadAdditional(tag, registryLookup);
            this.checkForOwner = tag.getBoolean("checkForOwner");
            String string = tag.getString("ownerUUID");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.ownerUUID = string;
            this.ownerLastSeen = tag.getLong("ownerLastSeen");
            ChunkLoaderBlockEntity chunkLoaderBlockEntity2 = this;
            try {
                chunkLoaderBlockEntity = chunkLoaderBlockEntity2;
                String string2 = tag.getString("disabledReason");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                disabledReason = DisabledReason.valueOf(string2);
            }
            catch (Exception exception) {
                void ignored;
                chunkLoaderBlockEntity = chunkLoaderBlockEntity2;
                ignored.printStackTrace();
                disabledReason = DisabledReason.NONE;
            }
            chunkLoaderBlockEntity.disabledReason = disabledReason;
            Tag tag2 = tag.get("enabledChunks");
            ListTag listTag = list = tag2 instanceof ListTag ? (ListTag)tag2 : null;
            if (listTag == null) break block3;
            ListTag it = listTag;
            boolean bl = false;
            this.enabledChunks = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tag it2 = (Tag)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
                CompoundTag ct = (CompoundTag)it2;
                this.enabledChunks.add((Pair<Integer, Integer>)new Pair((Object)ct.getInt("x"), (Object)ct.getInt("z")));
            }
        }
    }

    @Override
    @NotNull
    public CompoundTag writeClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag it = compoundTag = tag;
        boolean bl = false;
        this.saveAdditional(it, registryLookup);
        return compoundTag;
    }

    @Override
    public void readClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        this.loadAdditional(tag, registryLookup);
    }

    public void setChanged() {
        super.setChanged();
        this.dirty = true;
    }

    public final void markDirtyAndSync() {
        block0: {
            this.setChanged();
            Level level = this.level;
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) break block0;
            ServerLevel it = serverLevel;
            boolean bl = false;
            this.sync();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;", "entity", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;)V", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ChunkLoaderBlockEntity entity) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            if (entity.delay >= 20) {
                UUID uUID;
                try {
                    uUID = UUID.fromString(entity.getOwnerUUID());
                }
                catch (Exception ignored) {
                    uUID = null;
                }
                UUID playerUUID = uUID;
                if (!((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                    switch (WhenMappings.$EnumSwitchMapping$0[entity.getDisabledReason().ordinal()]) {
                        case 1: {
                            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
                            entity.setDisabledReason(DisabledReason.NONE);
                            entity.markDirtyAndSync();
                            break;
                        }
                        case 2: 
                        case 3: {
                            UUID uUID2 = playerUUID;
                            if (uUID2 != null) {
                                UUID validUUID = uUID2;
                                boolean bl = false;
                                ServerLevel serverLevel = world instanceof ServerLevel ? (ServerLevel)world : null;
                                if (serverLevel != null && (serverLevel = serverLevel.getServer()) != null && (serverLevel = serverLevel.getPlayerList()) != null && (serverLevel = serverLevel.getPlayer(validUUID)) != null) {
                                    ServerLevel it = serverLevel;
                                    boolean bl2 = false;
                                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
                                    entity.ownerLastSeen = System.currentTimeMillis();
                                    entity.setDisabledReason(DisabledReason.NONE);
                                    entity.markDirtyAndSync();
                                }
                            }
                            break;
                        }
                        case 4: {
                            UUID uUID3 = playerUUID;
                            if (uUID3 != null) {
                                UUID validUUID = uUID3;
                                boolean bl = false;
                                ServerLevel serverLevel = world instanceof ServerLevel ? (ServerLevel)world : null;
                                if (serverLevel != null) {
                                    ServerLevel world2 = serverLevel;
                                    boolean bl3 = false;
                                    MinecraftServer minecraftServer = world2.getServer();
                                    Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                                    ChunkLoaderState chunkLoaderState = ChunkLoaderState.Companion.getPersistentState(minecraftServer);
                                    if (chunkLoaderState.getLoaded(validUUID) >= KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxPerPlayer() && KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxPerPlayer() >= 0) break;
                                    world2.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
                                    entity.setDisabledReason(DisabledReason.NONE);
                                    entity.markDirtyAndSync();
                                }
                            }
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                    if (entity.getDisabledReason() != DisabledReason.NONE) {
                        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
                        return;
                    }
                    ServerLevel serverLevel = world instanceof ServerLevel ? (ServerLevel)world : null;
                    if (serverLevel != null) {
                        ServerLevel serverWorld = serverLevel;
                        boolean bl = false;
                        MinecraftServer minecraftServer = ((ServerLevel)world).getServer();
                        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                        ChunkLoaderState chunkLoaderState = ChunkLoaderState.Companion.getPersistentState(minecraftServer);
                        UUID uUID4 = playerUUID;
                        if (uUID4 != null) {
                            UUID validUUID = uUID4;
                            boolean bl4 = false;
                            ServerPlayer player = serverWorld.getServer().getPlayerList().getPlayer(validUUID);
                            if (player != null) {
                                entity.ownerLastSeen = System.currentTimeMillis();
                            } else if (entity.getCheckForOwner() || KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getCheckForPlayer()) {
                                serverWorld.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
                                entity.setDisabledReason(DisabledReason.OWNER_OFFLINE);
                                entity.markDirtyAndSync();
                                return;
                            }
                            if (KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxPerPlayer() > -1 && chunkLoaderState.getLoaded(validUUID) > KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxPerPlayer()) {
                                serverWorld.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
                                entity.setDisabledReason(DisabledReason.TOO_MANY_LOADERS);
                                entity.markDirtyAndSync();
                                return;
                            }
                        }
                        if (KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxOfflineTime() > -1L && (System.currentTimeMillis() - entity.ownerLastSeen) / (long)1000 > KibeMod.INSTANCE.getCONFIG().getChunkLoaderModule().getMaxOfflineTime()) {
                            serverWorld.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
                            entity.setDisabledReason(DisabledReason.OWNER_LONG_GONE);
                            entity.markDirtyAndSync();
                            return;
                        }
                        if (entity.dirty) {
                            chunkLoaderState.removePos(pos, serverWorld);
                            entity.dirty = false;
                        }
                        chunkLoaderState.addPos(pos, serverWorld);
                    }
                }
                entity.delay = 0;
            }
            int n = entity.delay;
            entity.delay = n + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DisabledReason.values().length];
                try {
                    nArray[DisabledReason.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DisabledReason.OWNER_OFFLINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DisabledReason.OWNER_LONG_GONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DisabledReason.TOO_MANY_LOADERS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity$DisabledReason;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "OWNER_OFFLINE", "OWNER_LONG_GONE", "TOO_MANY_LOADERS", "kibe"})
    public static final class DisabledReason
    extends Enum<DisabledReason> {
        public static final /* enum */ DisabledReason NONE = new DisabledReason();
        public static final /* enum */ DisabledReason OWNER_OFFLINE = new DisabledReason();
        public static final /* enum */ DisabledReason OWNER_LONG_GONE = new DisabledReason();
        public static final /* enum */ DisabledReason TOO_MANY_LOADERS = new DisabledReason();
        private static final /* synthetic */ DisabledReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DisabledReason[] values() {
            return (DisabledReason[])$VALUES.clone();
        }

        public static DisabledReason valueOf(String value) {
            return Enum.valueOf(DisabledReason.class, value);
        }

        @NotNull
        public static EnumEntries<DisabledReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = disabledReasonArray = new DisabledReason[]{DisabledReason.NONE, DisabledReason.OWNER_OFFLINE, DisabledReason.OWNER_LONG_GONE, DisabledReason.TOO_MANY_LOADERS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

