/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.serialization.MapCodec;
import io.github.lucaargolo.kibe.block.Placer;
import io.github.lucaargolo.kibe.blockentity.PlacerBlockEntity;
import io.github.lucaargolo.kibe.utils.menu.BlockScreenHandlerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018JC\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J/\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020$H\u0014\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010)\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u00020\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b+\u0010,J'\u0010.\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b.\u0010/J9\u00101\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u00100\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b1\u00102J;\u00108\u001a\u0002072\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u00104\u001a\u0002032\b\u00106\u001a\u0004\u0018\u000105H\u0014\u00a2\u0006\u0004\b8\u00109J\u0019\u0010;\u001a\u00020:2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000=H\u0014\u00a2\u0006\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lio/github/lucaargolo/kibe/block/Placer;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "block", "fromPos", "", "notify", "neighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "scheduledTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lio/github/lucaargolo/kibe/blockentity/PlacerBlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lio/github/lucaargolo/kibe/blockentity/PlacerBlockEntity;", "hasComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "newState", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Companion", "kibe"})
public final class Placer
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<Placer> CODEC;

    public Placer(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.FACING};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.TRIGGERED};
        stateManager.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)DispenserBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"with(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState = state.rotate(mirror.getRotation((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean isReceivingPower = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        Boolean triggered = (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED);
        if (isReceivingPower && !triggered.booleanValue()) {
            world.scheduleTick(pos, (Block)this, 4);
            Object object = state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(true));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.block.BlockState");
            world.setBlock(pos, (BlockState)object, 4);
        } else if (!isReceivingPower && triggered.booleanValue()) {
            Object object = state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(false));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.block.BlockState");
            world.setBlock(pos, (BlockState)object, 4);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        block3: {
            int index;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockPos facingPos = pos.relative(facing);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            PlacerBlockEntity placerBlockEntity = blockEntity instanceof PlacerBlockEntity ? (PlacerBlockEntity)blockEntity : null;
            if (placerBlockEntity == null) break block3;
            PlacerBlockEntity it = placerBlockEntity;
            boolean bl = false;
            for (index = 0; index < 9 && it.getItem(index).isEmpty(); ++index) {
            }
            if (index < 9) {
                ItemStack stack = it.getItem(index);
                Item item = stack.getItem();
                BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
                if (blockItem == null) {
                    return;
                }
                BlockItem item2 = blockItem;
                FakePlayer fakePlayer = FakePlayer.get((ServerLevel)world);
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
                Vec3 fakeHitPos = new Vec3((double)facingPos.getX() + 0.5, (double)facingPos.getY() + 0.0, (double)facingPos.getZ() + 0.5);
                item2.useOn(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(fakeHitPos, facing.getOpposite(), facingPos, false)));
                it.setChanged();
            }
        }
    }

    @NotNull
    public PlacerBlockEntity createBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new PlacerBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(@Nullable BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @NotNull BlockState newState, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Container container = blockEntity instanceof Container ? (Container)blockEntity : null;
            if (container != null) {
                Container it = container;
                boolean bl = false;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)it);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@Nullable BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @Nullable BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.openMenu((MenuProvider)new BlockScreenHandlerFactory((Block)this, pos, onUse.1.INSTANCE));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected MapCodec<Placer> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(Placer::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"createCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/block/Placer$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/Placer;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

