/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.serialization.MapCodec;
import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.blockentity.BigTorchBlockEntity;
import io.github.lucaargolo.kibe.effect.EffectCompendium;
import io.github.lucaargolo.kibe.mixin.SpawnHelperInvoker;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u00020\n2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001c\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010#\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b#\u0010$J)\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0016\u00a2\u0006\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lio/github/lucaargolo/kibe/block/CursedDirt;", "Lnet/minecraft/world/level/block/GrassBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "", "canSpread", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/LevelReader;", "worldView", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/biome/MobSpawnSettings$SpawnerData;", "getSpawnableMonster", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Lnet/minecraft/world/level/biome/MobSpawnSettings$SpawnerData;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nCursedDirt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CursedDirt.kt\nio/github/lucaargolo/kibe/block/CursedDirt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1878#2,3:150\n*S KotlinDebug\n*F\n+ 1 CursedDirt.kt\nio/github/lucaargolo/kibe/block/CursedDirt\n*L\n58#1:150,3\n*E\n"})
public final class CursedDirt
extends GrassBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<CursedDirt> CODEC;

    public CursedDirt(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(15))).setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.LEVEL};
        stateManager.add(propertyArray);
        super.createBlockStateDefinition(stateManager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (player.isShiftKeyDown() && !world.isClientSide) {
            List entries = ((ServerLevel)world).getChunkSource().getGenerator().getMobsAt(world.getBiome(pos), ((ServerLevel)world).structureManager(), MobCategory.MONSTER, pos.above()).unwrap();
            if (entries.isEmpty()) {
                player.displayClientMessage((Component)Component.literal((String)"Nothing can spawn"), false);
                return InteractionResult.SUCCESS;
            }
            MutableComponent names = Component.translatable((String)"chat.kibe.cursed_dirt.spawn");
            Intrinsics.checkNotNull((Object)entries);
            Iterable $this$forEachIndexed$iv = entries;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void entry;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MobSpawnSettings.SpawnerData spawnerData = (MobSpawnSettings.SpawnerData)item$iv;
                int index = n;
                boolean bl = false;
                names.append(entry.type.getDescription());
                if (index >= entries.size() - 1) continue;
                names.append(", ");
            }
            player.displayClientMessage((Component)names, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        EntityType mob;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (!world.hasChunkAt(pos)) {
            return;
        }
        if (world.isDay() && world.getLightLevelDependentMagicValue(pos.above()) > 0.5f && world.canSeeSky(pos.above())) {
            world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
            if (world.getBlockState(pos.above()).isAir()) {
                world.setBlockAndUpdate(pos.above(), Blocks.FIRE.defaultBlockState());
            }
        } else if (world.getMaxLocalRawBrightness(pos.above()) <= 7) {
            int n = CollectionsKt.count((Iterable)((Iterable)new IntRange(0, 3)));
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                BlockPos randomPos = pos.offset(new Vec3i(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1));
                Intrinsics.checkNotNull((Object)randomPos);
                if (!this.canSpread(state, world, randomPos)) continue;
                world.setBlockAndUpdate(randomPos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)GrassBlock.SNOWY, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)world.getBlockState(randomPos.above()).getBlock(), (Object)Blocks.SNOW)))).setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(((Number)((Object)state.getValue((Property)BlockStateProperties.LEVEL))).intValue() - 1)));
            }
        }
        world.scheduleTick(pos, state.getBlock(), random.nextInt(200));
        if (!(world.getFluidState(pos.above()).getType() instanceof EmptyFluid) && !Intrinsics.areEqual((Object)world.getFluidState(pos.above()).getType(), (Object)Fluids.WATER) && !Intrinsics.areEqual((Object)world.getFluidState(pos.above()).getType(), (Object)Fluids.FLOWING_WATER) || world.getDifficulty() == Difficulty.PEACEFUL || !((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_DOMOBSPAWNING)).get()) {
            return;
        }
        ChunkPos chunkPos = world.getChunk(pos).getPos();
        List entityList = world.getEntities(null, new AABB((double)chunkPos.getMinBlockX(), 0.0, (double)chunkPos.getMinBlockZ(), (double)chunkPos.getMaxBlockX(), 256.0, (double)chunkPos.getMaxBlockZ()), arg_0 -> CursedDirt.randomTick$lambda$2(CursedDirt::randomTick$lambda$1, arg_0));
        if (entityList.size() > KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getCursedDirtMobCap()) {
            return;
        }
        BigTorchBlockEntity.Companion.setException(true);
        BlockPos blockPos = pos.above();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        MobSpawnSettings.SpawnerData entry = this.getSpawnableMonster(world, blockPos, random);
        if (entry != null && SpawnHelperInvoker.invokeCanSpawn(world, (mob = entry.type).getCategory(), world.structureManager(), world.getChunkSource().getGenerator(), entry, pos.above().mutable(), 0.0)) {
            Entity entity;
            Entity entity2 = mob.create((Level)world);
            if (entity2 != null) {
                Entity it = entity2;
                boolean bl = false;
                it.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, it.getYRot(), it.getXRot());
                v2 = it.isInWall() ? null : (!world.addWithUUID(it) ? null : it);
            } else {
                v2 = entity = null;
            }
            if (entity instanceof Mob) {
                ((Mob)entity).finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)((Position)((Mob)entity).position()))), MobSpawnType.NATURAL, null);
            }
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance((Holder)EffectCompendium.INSTANCE.getCURSED(), 999999));
            }
        }
        BigTorchBlockEntity.Companion.setException(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSpread(BlockState state, ServerLevel world, BlockPos pos) {
        if (!Intrinsics.areEqual((Object)world.getBlockState(pos).getBlock(), (Object)Blocks.DIRT)) {
            if (!Intrinsics.areEqual((Object)world.getBlockState(pos).getBlock(), (Object)Blocks.GRASS_BLOCK)) return false;
        }
        BlockState blockState = world.getBlockState(pos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        if (!this.canSurvive(blockState, (LevelReader)world, pos)) return false;
        if (((Number)((Object)state.getValue((Property)BlockStateProperties.LEVEL))).intValue() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSurvive(BlockState state, LevelReader worldView, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = worldView.getBlockState(blockPos);
        if (blockState.getBlock() == Blocks.SNOW) {
            Comparable comparable = blockState.getValue((Property)SnowLayerBlock.LAYERS);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
            if ((Integer)comparable == 1) {
                return true;
            }
        }
        if (LightEngine.getLightBlockInto((BlockGetter)((BlockGetter)worldView), (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock((BlockGetter)worldView, blockPos)) >= worldView.getMaxLightLevel()) return false;
        return true;
    }

    private final MobSpawnSettings.SpawnerData getSpawnableMonster(ServerLevel world, BlockPos pos, RandomSource random) {
        Optional<MobSpawnSettings.SpawnerData> optional = SpawnHelperInvoker.invokePickRandomSpawnEntry(world, world.structureManager(), world.getChunkSource().getGenerator(), MobCategory.MONSTER, random, pos);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"invokePickRandomSpawnEntry(...)");
        Optional<MobSpawnSettings.SpawnerData> optionalEntry = optional;
        if (!optionalEntry.isPresent()) {
            return null;
        }
        MobSpawnSettings.SpawnerData spawnerData = optionalEntry.get();
        Intrinsics.checkNotNull((Object)spawnerData);
        MobSpawnSettings.SpawnerData entry = spawnerData;
        if (KibeMod.INSTANCE.getCONFIG().getMiscellaneousModule().getCursedDirtDenyList().contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entry.type).toString())) {
            return null;
        }
        boolean it = SpawnPlacements.checkSpawnRules((EntityType)entry.type, (ServerLevelAccessor)((ServerLevelAccessor)world), (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)world.random);
        boolean bl = false;
        return it ? entry : null;
    }

    @NotNull
    public MapCodec<GrassBlock> codec() {
        MapCodec<CursedDirt> mapCodec = CODEC;
        Intrinsics.checkNotNull(mapCodec, (String)"null cannot be cast to non-null type com.mojang.serialization.MapCodec<net.minecraft.block.GrassBlock>");
        return mapCodec;
    }

    private static final boolean randomTick$lambda$1(Entity it) {
        return it instanceof Mob;
    }

    private static final boolean randomTick$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        MapCodec mapCodec = GrassBlock.simpleCodec(CursedDirt::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"createCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/block/CursedDirt$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/CursedDirt;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

