/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.serialization.MapCodec;
import io.github.lucaargolo.kibe.block.Breaker;
import io.github.lucaargolo.kibe.blockentity.BreakerBlockEntity;
import io.github.lucaargolo.kibe.utils.menu.BlockScreenHandlerFactory;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018JC\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J/\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020$H\u0014\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010)\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010+\u001a\u00020\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b+\u0010,J'\u0010.\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b.\u0010/J9\u00101\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u00100\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b1\u00102J;\u00108\u001a\u0002072\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u00104\u001a\u0002032\b\u00106\u001a\u0004\u0018\u000105H\u0014\u00a2\u0006\u0004\b8\u00109J\u0019\u0010;\u001a\u00020:2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000=H\u0014\u00a2\u0006\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lio/github/lucaargolo/kibe/block/Breaker;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "block", "fromPos", "", "notify", "neighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "scheduledTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lio/github/lucaargolo/kibe/blockentity/BreakerBlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lio/github/lucaargolo/kibe/blockentity/BreakerBlockEntity;", "hasComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "newState", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nBreaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Breaker.kt\nio/github/lucaargolo/kibe/block/Breaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1869#2,2:129\n*S KotlinDebug\n*F\n+ 1 Breaker.kt\nio/github/lucaargolo/kibe/block/Breaker\n*L\n69#1:129,2\n*E\n"})
public final class Breaker
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<Breaker> CODEC;

    public Breaker(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.FACING};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.TRIGGERED};
        stateManager.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Object object = state.setValue((Property)DispenserBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"with(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState = state.rotate(mirror.getRotation((Direction)state.getValue((Property)DispenserBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"rotate(...)");
        return blockState;
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean isReceivingPower = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        Boolean triggered = (Boolean)state.getValue((Property)DispenserBlock.TRIGGERED);
        if (isReceivingPower && !triggered.booleanValue()) {
            world.scheduleTick(pos, (Block)this, 4);
            Object object = state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(true));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.block.BlockState");
            world.setBlock(pos, (BlockState)object, 4);
        } else if (!isReceivingPower && triggered.booleanValue()) {
            Object object = state.setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(false));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.block.BlockState");
            world.setBlock(pos, (BlockState)object, 4);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockPos facingPos = pos.relative(facing);
            BlockState facingState = world.getBlockState(facingPos);
            if (!(facingState.getDestroySpeed((BlockGetter)world, facingPos) >= 0.0f)) break block5;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            BreakerBlockEntity breakerBlockEntity = blockEntity instanceof BreakerBlockEntity ? (BreakerBlockEntity)blockEntity : null;
            if (breakerBlockEntity != null) {
                BreakerBlockEntity it = breakerBlockEntity;
                boolean bl = false;
                List stackList = Block.getDrops((BlockState)facingState, (ServerLevel)world, (BlockPos)facingPos, (BlockEntity)world.getBlockEntity(facingPos));
                for (ItemStack stack : stackList) {
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)it.getContainerSize());
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int slot = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (stack.isEmpty()) continue;
                        ItemStack stk = it.getItem(slot);
                        if (stk.isEmpty()) {
                            ItemStack itemStack = stack.copy();
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                            it.setItem(slot, itemStack);
                            stack.shrink(stack.getCount());
                            continue;
                        }
                        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stk)) continue;
                        if (stk.getCount() + stack.getCount() < stk.getMaxStackSize()) {
                            stk.grow(stack.getCount());
                            stack.shrink(stack.getCount());
                            continue;
                        }
                        int value = stk.getMaxStackSize() - stk.getCount();
                        stk.grow(value);
                        stack.shrink(value);
                    }
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)((Level)world), (double)((double)(pos.getX() + facing.getStepX()) + 0.5), (double)((double)(pos.getY() + facing.getStepY()) + 0.5), (double)((double)(pos.getZ() + facing.getStepZ()) + 0.5), (ItemStack)stack);
                }
                world.destroyBlock(facingPos, false);
                it.setChanged();
            }
        }
    }

    @NotNull
    public BreakerBlockEntity createBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new BreakerBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(@Nullable BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @NotNull BlockState newState, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Container container = blockEntity instanceof Container ? (Container)blockEntity : null;
            if (container != null) {
                Container it = container;
                boolean bl = false;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)it);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@Nullable BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @Nullable BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.openMenu((MenuProvider)new BlockScreenHandlerFactory((Block)this, pos, onUse.1.INSTANCE));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected MapCodec<Breaker> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(Breaker::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"createCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/block/Breaker$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/Breaker;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

