/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lucaargolo.kibe.block.BlockGenerator;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.blockentity.BlockGeneratorBlockEntity;
import io.github.lucaargolo.kibe.utils.menu.BlockScreenHandlerFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0001<B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\r2\u0016\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015JG\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001c\"\n\b\u0000\u0010\u0016*\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J;\u0010(\u001a\u00020'2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010$\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010%H\u0014\u00a2\u0006\u0004\b(\u0010)J9\u0010-\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020+H\u0014\u00a2\u0006\u0004\b-\u0010.J\u0019\u0010/\u001a\u00020+2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b/\u00100J)\u00102\u001a\u0002012\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b2\u00103J\u0019\u00105\u001a\u0002042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b5\u00106J\u0015\u00108\u001a\b\u0012\u0004\u0012\u00020\u000007H\u0014\u00a2\u0006\u0004\b8\u00109R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010:R\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010;\u00a8\u0006="}, d2={"Lio/github/lucaargolo/kibe/block/BlockGenerator;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "Lnet/minecraft/world/level/block/Block;", "block", "", "rate", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Lnet/minecraft/world/level/block/Block;F)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/BlockPos;", "pos", "state", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "Lnet/minecraft/world/level/Level;", "world", "blockState", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "newState", "", "notify", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "hasComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/Block;", "F", "Companion", "kibe"})
public final class BlockGenerator
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Block block;
    private float rate;
    @NotNull
    private static final MapCodec<BlockGenerator> CODEC;

    public BlockGenerator(@NotNull BlockBehaviour.Properties settings, @NotNull Block block, float rate) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super(settings);
        this.block = block;
        this.rate = rate;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.LEVEL_COMPOSTER};
        stateManager.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new BlockGeneratorBlockEntity(this, this.block, this.rate, pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nullable Level world, @Nullable BlockState blockState, @Nullable BlockEntityType<T> blockEntityType) {
        BlockGeneratorBlockEntity.Companion companion = BlockGeneratorBlockEntity.Companion;
        return BaseEntityBlock.createTickerHelper(blockEntityType, BlockEntityCompendium.INSTANCE.getBLOCK_GENERATOR(), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ BlockGeneratorBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, BlockGeneratorBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(0));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@Nullable BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @Nullable BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.openMenu((MenuProvider)new BlockScreenHandlerFactory((Block)this, pos, onUse.1.INSTANCE));
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @NotNull BlockState newState, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Container container = blockEntity instanceof Container ? (Container)blockEntity : null;
            if (container != null) {
                Container it = container;
                boolean bl = false;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)it);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    protected boolean hasAnalogOutputSignal(@Nullable BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@Nullable BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected MapCodec<BlockGenerator> codec() {
        return CODEC;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)BaseEntityBlock.propertiesCodec(), (App)Block.CODEC.fieldOf("block").forGetter(arg_0 -> BlockGenerator.CODEC$lambda$0$0((KMutableProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.FLOAT.fieldOf("rate").forGetter(arg_0 -> BlockGenerator.CODEC$lambda$0$1((KMutableProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, BlockGenerator::new);
    }

    private static final Block CODEC$lambda$0$0(KMutableProperty1 $tmp0, BlockGenerator p0) {
        return (Block)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Float CODEC$lambda$0$1(KMutableProperty1 $tmp0, BlockGenerator p0) {
        return (Float)((Function1)$tmp0).invoke((Object)p0);
    }

    public static final /* synthetic */ Block access$getBlock$p(BlockGenerator $this) {
        return $this.block;
    }

    public static final /* synthetic */ void access$setBlock$p(BlockGenerator $this, Block block) {
        $this.block = block;
    }

    public static final /* synthetic */ float access$getRate$p(BlockGenerator $this) {
        return $this.rate;
    }

    public static final /* synthetic */ void access$setRate$p(BlockGenerator $this, float f) {
        $this.rate = f;
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(BlockGenerator::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/block/BlockGenerator$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/BlockGenerator;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

