/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.StringUtils;

public class InventorySorterCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder invsorterBuilder = (LiteralArgumentBuilder)Commands.literal((String)"invsorter").requires(cs -> cs.hasPermission(1));
        Stream.of(CommandAction.values()).forEach(a -> invsorterBuilder.then(a.buildCommand()));
        invsorterBuilder.executes(InventorySorterCommand::help);
        dispatcher.register(invsorterBuilder);
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"inventorysorter.commands.inventorysorter.usage"));
        return 0;
    }

    private static SuggestionProvider<CommandSourceStack> suggester(Supplier<Stream<ResourceLocation>> containers) {
        return (ctx, suggestionbuilder) -> SharedSuggestionProvider.suggestResource((Stream)((Stream)containers.get()), (SuggestionsBuilder)suggestionbuilder);
    }

    private static enum CommandAction {
        BLADD(InventorySorter::blackListAdd, 1, (RequiredArgumentBuilder<CommandSourceStack, ResourceLocation>)Commands.argument((String)"container", (ArgumentType)new ContainerResourceLocationArgument()).suggests(InventorySorterCommand.suggester(InventorySorter::listContainers))),
        BLREMOVE(InventorySorter::blackListRemove, 4, (RequiredArgumentBuilder<CommandSourceStack, ResourceLocation>)Commands.argument((String)"container", (ArgumentType)new ContainerResourceLocationArgument()).suggests(InventorySorterCommand.suggester(InventorySorter::listBlacklist))),
        SHOWLAST(InventorySorter::showLast, 1, null),
        LIST(InventorySorter::showBlacklist, 1, null);

        private final int permissionLevel;
        private RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> suggester;
        private final ToIntFunction<CommandContext<CommandSourceStack>> action;

        private CommandAction(ToIntFunction<CommandContext<CommandSourceStack>> action, int permissionLevel, RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> suggester) {
            this.action = action;
            this.permissionLevel = permissionLevel;
            this.suggester = suggester;
        }

        public ArgumentBuilder<CommandSourceStack, ?> buildCommand() {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.literal((String)StringUtils.toLowerCase((String)this.name())).requires(cs -> cs.hasPermission(this.permissionLevel));
            if (this.suggester != null) {
                base.then(this.suggester.executes(this.action::applyAsInt));
            } else {
                base.executes(this.action::applyAsInt);
            }
            return base;
        }
    }

    public static class ContainerResourceLocationArgument
    implements ArgumentType<ResourceLocation> {
        private static final List<String> EXAMPLES = Collections.singletonList("minecraft:chest");

        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            return ResourceLocation.read((StringReader)reader);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

