/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.misc.VehicleData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class AircraftDataMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, AircraftDataMessage> STREAM_CODEC = StreamCodec.ofMember(AircraftDataMessage::encode, AircraftDataMessage::new);
    public static final CustomPacketPayload.Type<AircraftDataMessage> TYPE = Message.createType("aircraft_data");
    private final Map<ResourceLocation, VehicleData> data;

    public CustomPacketPayload.Type<AircraftDataMessage> type() {
        return TYPE;
    }

    public AircraftDataMessage() {
        this.data = VehicleDataLoader.REGISTRY;
    }

    public AircraftDataMessage(RegistryFriendlyByteBuf buffer) {
        this.data = new HashMap<ResourceLocation, VehicleData>();
        int dataCount = buffer.readInt();
        for (int i = 0; i < dataCount; ++i) {
            ResourceLocation identifier = buffer.readResourceLocation();
            this.data.put(identifier, new VehicleData(buffer));
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.data.size());
        for (ResourceLocation identifier : this.data.keySet()) {
            buffer.writeResourceLocation(identifier);
            this.data.get(identifier).encode(buffer);
        }
    }

    @Override
    public void receiveClient() {
        VehicleDataLoader.CLIENT_REGISTRY.clear();
        VehicleDataLoader.CLIENT_REGISTRY.putAll(this.data);
    }
}

