/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.BlockModel;

public class VanillaModelSerializer
implements JsonSerializer<BlockModel> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new VanillaModelSerializer()).disableHtmlEscaping().setPrettyPrinting().create();

    private VanillaModelSerializer() {
    }

    public JsonElement serialize(BlockModel src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        if (src.parentLocation != null) {
            json.addProperty("parent", src.parentLocation.toString());
        }
        if (!src.textureMap.isEmpty()) {
            JsonObject textures = new JsonObject();
            src.textureMap.forEach((key, texture) -> textures.addProperty(key, (String)texture.map(m -> m.texture().toString(), s -> s)));
            json.add("textures", (JsonElement)textures);
        }
        if (src.hasAmbientOcclusion != null && !src.hasAmbientOcclusion.booleanValue()) {
            json.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (src.guiLight != null) {
            json.addProperty("gui_light", src.guiLight.name().toLowerCase(Locale.ROOT));
        }
        return json;
    }
}

