/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.mixins.Item;

import com.moepus.flerovium.functions.MatrixStuff;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.joml.Math;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemTransform.class}, remap=false)
public abstract class ItemTransformMixin {
    @Final
    @Shadow
    public Vector3f rotation;
    @Final
    @Shadow
    public Vector3f translation;
    @Final
    @Shadow
    public Vector3f scale;
    @Final
    @Shadow(remap=false)
    public Vector3f rightRotation;
    @Unique
    boolean flerovium$noRot = false;
    @Unique
    boolean flerovium$noTrans = false;
    @Unique
    boolean flerovium$scaleSameAndPositive = false;
    @Unique
    boolean flerovium$noRightRot = false;
    @Unique
    float flerovium$sinX = 0.0f;
    @Unique
    float flerovium$cosX = 0.0f;
    @Unique
    float flerovium$sinY = 0.0f;
    @Unique
    float flerovium$cosY = 0.0f;

    @Inject(method={"<init>(Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;)V"}, at={@At(value="TAIL")}, remap=false)
    public void init(Vector3f p_254427_, Vector3f p_254496_, Vector3f p_254022_, Vector3f rightRotation, CallbackInfo ci) {
        if (this.rotation.equals(0.0f, 0.0f, 0.0f)) {
            this.flerovium$noRot = true;
        } else if (this.rotation.z == 0.0f) {
            float radX = Math.toRadians((float)this.rotation.x);
            float radY = Math.toRadians((float)this.rotation.y);
            this.flerovium$sinX = Math.sin((float)radX);
            this.flerovium$sinY = Math.sin((float)radY);
            this.flerovium$cosX = Math.cosFromSin((float)this.flerovium$sinX, (float)radX);
            this.flerovium$cosY = Math.cosFromSin((float)this.flerovium$sinY, (float)radY);
        }
        if (this.translation.equals(0.0f, 0.0f, 0.0f)) {
            this.flerovium$noTrans = true;
        }
        if (this.scale.x() == this.scale.y() && this.scale.y() == this.scale.z() && this.scale.x() > 0.0f) {
            this.flerovium$scaleSameAndPositive = true;
        } else if (this.scale.z() == 0.0f) {
            this.scale.z = 1.0E-5f;
        }
        if (rightRotation.equals(0.0f, 0.0f, 0.0f)) {
            this.flerovium$noRightRot = true;
        }
    }

    @Inject(method={"apply(ZLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void apply(boolean doFlip, PoseStack pose, CallbackInfo ci) {
        if (this != ItemTransform.NO_TRANSFORM) {
            float flip;
            float f = flip = doFlip ? -1.0f : 1.0f;
            if (!this.flerovium$noTrans) {
                pose.translate(flip * this.translation.x(), this.translation.y(), this.translation.z());
            }
            if (!this.flerovium$noRot) {
                if (this.rotation.z() == 0.0f) {
                    PoseStack.Pose last = pose.last();
                    float flipY = flip * this.flerovium$sinY;
                    MatrixStuff.rotateXY(last.pose(), this.flerovium$sinX, this.flerovium$cosX, flipY, this.flerovium$cosY);
                    MatrixStuff.rotateXY(last.normal(), this.flerovium$sinX, this.flerovium$cosX, flipY, this.flerovium$cosY);
                } else {
                    pose.mulPose(TransformationHelper.quatFromXYZ((float)this.rotation.x(), (float)(this.rotation.y() * flip), (float)(this.rotation.z() * flip), (boolean)true));
                }
            }
            if (this.flerovium$scaleSameAndPositive) {
                pose.last().pose().scale(this.scale.x(), this.scale.x(), this.scale.x());
            } else {
                pose.scale(this.scale.x(), this.scale.y(), this.scale.z());
            }
            if (!this.flerovium$noRightRot) {
                pose.mulPose(TransformationHelper.quatFromXYZ((float)this.rightRotation.x(), (float)(this.rightRotation.y() * flip), (float)(this.rightRotation.z() * flip), (boolean)true));
            }
        }
        ci.cancel();
    }
}

