/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.mixins.Entity;

import com.moepus.flerovium.Flerovium;
import com.moepus.flerovium.Iris.IrisEntityRenderer;
import com.moepus.flerovium.Iris.IrisEntityVertex;
import com.moepus.flerovium.mixins.Entity.ModelCuboidAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.EntityVertex;
import net.caffeinemc.mods.sodium.client.render.immediate.model.EntityRenderer;
import net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid;
import net.caffeinemc.mods.sodium.client.util.Int2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class}, remap=false, priority=2005)
public abstract class EntityRendererMixin {
    @Shadow
    @Final
    private static int[] CUBE_FACE_NORMAL;
    @Shadow
    @Final
    private static long[] CUBE_VERTEX_XY;
    @Shadow
    @Final
    private static long[] CUBE_VERTEX_ZW;

    @Shadow
    private static void setVertex(int vertexIndex, float x, float y, float z, int color) {
    }

    @Shadow
    private static long writeVertex(long ptr, int vertexIndex, long packedUv, long packedOverlayLight, int packedNormal) {
        return 0L;
    }

    @Shadow
    private static void prepareNormalsIfChanged(PoseStack.Pose matrices) {
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"renderCuboid"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onRenderCuboid(PoseStack.Pose matrices, VertexBufferWriter writer, ModelCuboid cuboid, int light, int overlay, int color, CallbackInfo ci) {
        ci.cancel();
        if (!(writer instanceof BufferBuilder)) ** GOTO lbl-1000
        bb = (BufferBuilder)writer;
        if (bb.format == IrisEntityVertex.FORMAT) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isRenderingIrisEntity = v0;
        cullingMask = EntityRendererMixin.flerovium$prepareVertices(matrices, cuboid, color);
        EntityRendererMixin.prepareNormalsIfChanged(matrices);
        stack = MemoryStack.stackPush();
        try {
            packedOverlayLight = Int2.pack((int)overlay, (int)light);
            if (isRenderingIrisEntity) {
                vertexBuffer = stack.nmalloc(64, IrisEntityVertex.STRIDE * 24);
                vertexCount = IrisEntityRenderer.emitQuads(vertexBuffer, cuboid, packedOverlayLight, cullingMask, EntityRendererMixin.CUBE_VERTEX_XY, EntityRendererMixin.CUBE_VERTEX_ZW, EntityRendererMixin.CUBE_FACE_NORMAL);
                if (vertexCount > 0) {
                    writer.push(stack, vertexBuffer, vertexCount, IrisEntityVertex.FORMAT);
                }
            } else {
                vertexBuffer = stack.nmalloc(64, 864);
                vertexCount = EntityRendererMixin.flerovium$emitQuads(vertexBuffer, cuboid, packedOverlayLight, cullingMask);
                if (vertexCount > 0) {
                    writer.push(stack, vertexBuffer, vertexCount, EntityVertex.FORMAT);
                }
            }
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
    }

    @Unique
    private static int flerovium$prepareVertices(PoseStack.Pose matrices, ModelCuboid cuboid, int color) {
        Matrix4f pose = matrices.pose();
        float vxx = pose.m00() * cuboid.sizeX;
        float vxy = pose.m01() * cuboid.sizeX;
        float vxz = pose.m02() * cuboid.sizeX;
        float vyx = pose.m10() * cuboid.sizeY;
        float vyy = pose.m11() * cuboid.sizeY;
        float vyz = pose.m12() * cuboid.sizeY;
        float vzx = pose.m20() * cuboid.sizeZ;
        float vzy = pose.m21() * cuboid.sizeZ;
        float vzz = pose.m22() * cuboid.sizeZ;
        float c000x = MatrixHelper.transformPositionX((Matrix4f)pose, (float)cuboid.originX, (float)cuboid.originY, (float)cuboid.originZ);
        float c000y = MatrixHelper.transformPositionY((Matrix4f)pose, (float)cuboid.originX, (float)cuboid.originY, (float)cuboid.originZ);
        float c000z = MatrixHelper.transformPositionZ((Matrix4f)pose, (float)cuboid.originX, (float)cuboid.originY, (float)cuboid.originZ);
        EntityRendererMixin.setVertex(0, c000x, c000y, c000z, color);
        float c100x = c000x + vxx;
        float c100y = c000y + vxy;
        float c100z = c000z + vxz;
        EntityRendererMixin.setVertex(1, c100x, c100y, c100z, color);
        float c110x = c100x + vyx;
        float c110y = c100y + vyy;
        float c110z = c100z + vyz;
        EntityRendererMixin.setVertex(2, c110x, c110y, c110z, color);
        float c010x = c000x + vyx;
        float c010y = c000y + vyy;
        float c010z = c000z + vyz;
        EntityRendererMixin.setVertex(3, c010x, c010y, c010z, color);
        float c001x = c000x + vzx;
        float c001y = c000y + vzy;
        float c001z = c000z + vzz;
        EntityRendererMixin.setVertex(4, c001x, c001y, c001z, color);
        float c101x = c100x + vzx;
        float c101y = c100y + vzy;
        float c101z = c100z + vzz;
        EntityRendererMixin.setVertex(5, c101x, c101y, c101z, color);
        float c111x = c110x + vzx;
        float c111y = c110y + vzy;
        float c111z = c110z + vzz;
        EntityRendererMixin.setVertex(6, c111x, c111y, c111z, color);
        float c011x = c010x + vzx;
        float c011y = c010y + vzy;
        float c011z = c010z + vzz;
        EntityRendererMixin.setVertex(7, c011x, c011y, c011z, color);
        int cullingMask = ((ModelCuboidAccessor)cuboid).getCullMask();
        if (matrices.pose().m32() <= -16.0f && Flerovium.config.entityBackFaceCulling && RenderSystem.getModelViewMatrix().m32() == 0.0f) {
            Matrix3f normal = matrices.normal();
            float posX = c000x + c011x;
            float posY = c000y + c011y;
            float posZ = c000z + c011z;
            if (posX * normal.m00 + posY * normal.m01 + posZ * normal.m02 < 0.0f) {
                cullingMask &= ~(1 << (cuboid.sizeX > 0.0f ? 4 : 2));
            }
            if ((posX = c100x + c111x) * normal.m00 + (posY = c100y + c111y) * normal.m01 + (posZ = c100z + c111z) * normal.m02 > 0.0f) {
                cullingMask &= ~(1 << (cuboid.sizeX > 0.0f ? 2 : 4));
            }
            if ((posX = c000x + c110x) * normal.m20 + (posY = c000y + c110y) * normal.m21 + (posZ = c000z + c110z) * normal.m22 < 0.0f) {
                cullingMask &= 0xFFFFFFF7;
            }
            if ((posX = c001x + c111x) * normal.m20 + (posY = c001y + c111y) * normal.m21 + (posZ = c001z + c111z) * normal.m22 > 0.0f) {
                cullingMask &= 0xFFFFFFDF;
            }
            if ((posX = c000x + c101x) * normal.m10 + (posY = c000y + c101y) * normal.m11 + (posZ = c000z + c101z) * normal.m12 < 0.0f) {
                cullingMask &= 0xFFFFFFFE;
            }
            if ((posX = c010x + c111x) * normal.m10 + (posY = c010y + c111y) * normal.m11 + (posZ = c010z + c111z) * normal.m12 > 0.0f) {
                cullingMask &= 0xFFFFFFFD;
            }
        }
        return cullingMask;
    }

    @Unique
    private static int flerovium$emitQuads(long buffer, ModelCuboid cuboid, long packedOverlayLight, int cullMask) {
        long ptr = buffer;
        int[] normals = cuboid.normals;
        int[] positions = cuboid.positions;
        long[] textures = cuboid.textures;
        int vertexCount = 0;
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            if ((cullMask & 1 << faceIndex) == 0) continue;
            int elementOffset = faceIndex * 4;
            int packedNormal = CUBE_FACE_NORMAL[normals[faceIndex]];
            ptr = EntityRendererMixin.writeVertex(ptr, positions[elementOffset + 0], textures[elementOffset + 0], packedOverlayLight, packedNormal);
            ptr = EntityRendererMixin.writeVertex(ptr, positions[elementOffset + 1], textures[elementOffset + 1], packedOverlayLight, packedNormal);
            ptr = EntityRendererMixin.writeVertex(ptr, positions[elementOffset + 2], textures[elementOffset + 2], packedOverlayLight, packedNormal);
            ptr = EntityRendererMixin.writeVertex(ptr, positions[elementOffset + 3], textures[elementOffset + 3], packedOverlayLight, packedNormal);
            vertexCount += 4;
        }
        return vertexCount;
    }
}

