/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.Iris;

import com.moepus.flerovium.Iris.IrisEntityVertex;
import com.moepus.flerovium.functions.MathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class IrisSimpleBakedItemRenderer {
    private static final MemoryStack STACK = MemoryStack.create();
    private static final long SCRATCH_BUFFER;
    private static long BUFFER_PTR;
    private static int BUFFED_VERTEX;
    private static final Vector2f uv0;
    private static final Vector2f uv1;
    private static final Vector2f uv2;
    private static final Vector2f uv3;

    private static void putBulkData(VertexBufferWriter writer, PoseStack.Pose pose, BakedQuad bakedQuad, int light, int overlay, int color, int faces) {
        int[] vertices = bakedQuad.getVertices();
        if (vertices.length != 32) {
            return;
        }
        Matrix4f pose_matrix = pose.pose();
        int baked_normal = vertices[7];
        float unpackedX = NormI8.unpackX((int)baked_normal);
        float unpackedY = NormI8.unpackY((int)baked_normal);
        float unpackedZ = NormI8.unpackZ((int)baked_normal);
        float nx = MatrixHelper.transformNormalX((Matrix3f)pose.normal(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float ny = MatrixHelper.transformNormalY((Matrix3f)pose.normal(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float nz = MatrixHelper.transformNormalZ((Matrix3f)pose.normal(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        int n = MathUtil.packSafe(nx, ny, nz);
        float x = Float.intBitsToFloat(vertices[0]);
        float y = Float.intBitsToFloat(vertices[1]);
        float z = Float.intBitsToFloat(vertices[2]);
        float pos0_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos0_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos0_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        x = Float.intBitsToFloat(vertices[16]);
        y = Float.intBitsToFloat(vertices[17]);
        z = Float.intBitsToFloat(vertices[18]);
        float pos2_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos2_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos2_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        if ((faces & 0x40) != 0 && (pos0_x + pos2_x) * nx + (pos0_y + pos2_y) * ny + (pos0_z + pos2_z) * nz > 0.0f && ((BakedQuadView)bakedQuad).getNormalFace() != ModelQuadFacing.UNASSIGNED) {
            return;
        }
        x = Float.intBitsToFloat(vertices[8]);
        y = Float.intBitsToFloat(vertices[9]);
        z = Float.intBitsToFloat(vertices[10]);
        float pos1_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos1_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos1_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        x = Float.intBitsToFloat(vertices[24]);
        y = Float.intBitsToFloat(vertices[25]);
        z = Float.intBitsToFloat(vertices[26]);
        float pos3_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos3_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos3_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        int c = color != -1 ? ColorMixer.mulComponentWise((int)color, (int)vertices[3]) : vertices[3];
        uv0.set(Float.intBitsToFloat(vertices[4]), Float.intBitsToFloat(vertices[5]));
        uv1.set(Float.intBitsToFloat(vertices[12]), Float.intBitsToFloat(vertices[13]));
        uv2.set(Float.intBitsToFloat(vertices[20]), Float.intBitsToFloat(vertices[21]));
        uv3.set(Float.intBitsToFloat(vertices[28]), Float.intBitsToFloat(vertices[29]));
        float mid_u = (IrisSimpleBakedItemRenderer.uv0.x + IrisSimpleBakedItemRenderer.uv1.x + IrisSimpleBakedItemRenderer.uv2.x + IrisSimpleBakedItemRenderer.uv3.x) / 4.0f;
        float mid_v = (IrisSimpleBakedItemRenderer.uv0.y + IrisSimpleBakedItemRenderer.uv1.y + IrisSimpleBakedItemRenderer.uv2.y + IrisSimpleBakedItemRenderer.uv3.y) / 4.0f;
        int baked = vertices[6];
        int l = Math.max((int)((baked & 0xFFFF) << 16 | baked >> 16), (int)light);
        long WRITE_PTR = BUFFER_PTR;
        IrisEntityVertex.write(WRITE_PTR, pos0_x, pos0_y, pos0_z, c, IrisSimpleBakedItemRenderer.uv0.x, IrisSimpleBakedItemRenderer.uv0.y, mid_u, mid_v, overlay, l, n, -1);
        IrisEntityVertex.write(WRITE_PTR += (long)IrisEntityVertex.STRIDE, pos1_x, pos1_y, pos1_z, c, IrisSimpleBakedItemRenderer.uv1.x, IrisSimpleBakedItemRenderer.uv1.y, mid_u, mid_v, overlay, l, n, -1);
        IrisEntityVertex.write(WRITE_PTR += (long)IrisEntityVertex.STRIDE, pos2_x, pos2_y, pos2_z, c, IrisSimpleBakedItemRenderer.uv2.x, IrisSimpleBakedItemRenderer.uv2.y, mid_u, mid_v, overlay, l, n, -1);
        IrisEntityVertex.write(WRITE_PTR += (long)IrisEntityVertex.STRIDE, pos3_x, pos3_y, pos3_z, c, IrisSimpleBakedItemRenderer.uv3.x, IrisSimpleBakedItemRenderer.uv3.y, mid_u, mid_v, overlay, l, n, -1);
        BUFFER_PTR = WRITE_PTR += (long)IrisEntityVertex.STRIDE;
        BUFFED_VERTEX += 4;
        if (IrisSimpleBakedItemRenderer.isBufferMax()) {
            IrisSimpleBakedItemRenderer.flush(writer);
        }
    }

    private static void flush(VertexBufferWriter writer) {
        if (BUFFED_VERTEX == 0) {
            return;
        }
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, BUFFED_VERTEX, IrisEntityVertex.FORMAT);
        STACK.pop();
        BUFFER_PTR = SCRATCH_BUFFER;
        BUFFED_VERTEX = 0;
    }

    private static boolean isBufferMax() {
        return BUFFED_VERTEX >= 48;
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexBufferWriter writer, int faces, List<BakedQuad> bakedQuads, int light, int overlay, ItemStack itemStack, ItemColors itemColors) {
        for (BakedQuad bakedQuad : bakedQuads) {
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            if ((faces & 1 << bakedQuad.getDirection().ordinal()) == 0) {
                if (quad.getSprite() == null) continue;
                SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
                continue;
            }
            int color = -1;
            if (quad.hasColor()) {
                color = ColorARGB.toABGR((int)itemColors.getColor(itemStack, quad.getColorIndex()));
            }
            IrisSimpleBakedItemRenderer.putBulkData(writer, pose, bakedQuad, light, overlay, color, faces);
            if (quad.getSprite() == null) continue;
            SpriteUtil.INSTANCE.markSpriteActive(quad.getSprite());
        }
    }

    public static void render(SimpleBakedModel model, int faces, ItemStack itemStack, int packedLight, int packedOverlay, PoseStack poseStack, VertexBufferWriter writer, ItemColors itemColors) {
        PoseStack.Pose pose = poseStack.last();
        for (Direction direction : Direction.values()) {
            IrisSimpleBakedItemRenderer.renderQuadList(pose, writer, faces, model.getQuads(null, direction, null), packedLight, packedOverlay, itemStack, itemColors);
        }
        IrisSimpleBakedItemRenderer.renderQuadList(pose, writer, faces, model.getQuads(null, null, null), packedLight, packedOverlay, itemStack, itemColors);
        IrisSimpleBakedItemRenderer.flush(writer);
    }

    static {
        BUFFER_PTR = SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)(48 * IrisEntityVertex.STRIDE));
        BUFFED_VERTEX = 0;
        uv0 = new Vector2f();
        uv1 = new Vector2f();
        uv2 = new Vector2f();
        uv3 = new Vector2f();
    }
}

