/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.Iris;

import com.moepus.flerovium.Flerovium;
import com.moepus.flerovium.Iris.IrisEntityVertex;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid;
import net.caffeinemc.mods.sodium.client.util.Int2;
import net.irisshaders.iris.vertices.NormalHelper;
import org.joml.Vector2f;

public class IrisEntityRenderer {
    private static final Vector2f uv0 = new Vector2f();
    private static final Vector2f uv1 = new Vector2f();
    private static final Vector2f uv2 = new Vector2f();
    private static final Vector2f uv3 = new Vector2f();

    public static int emitQuads(long buffer, ModelCuboid cuboid, long packedOverlayLight, int cullMask, long[] CUBE_VERTEX_XY, long[] CUBE_VERTEX_ZW, int[] CUBE_FACE_NORMAL) {
        long ptr = buffer;
        int[] normals = cuboid.normals;
        int[] positions = cuboid.positions;
        long[] textures = cuboid.textures;
        int vertexCount = 0;
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            if ((cullMask & 1 << faceIndex) == 0) continue;
            int elementOffset = faceIndex * 4;
            int packedNormal = CUBE_FACE_NORMAL[normals[faceIndex]];
            IrisEntityRenderer.unpackUV(textures[elementOffset + 0], uv0);
            IrisEntityRenderer.unpackUV(textures[elementOffset + 1], uv1);
            IrisEntityRenderer.unpackUV(textures[elementOffset + 2], uv2);
            IrisEntityRenderer.unpackUV(textures[elementOffset + 3], uv3);
            float mid_u = (IrisEntityRenderer.uv0.x + IrisEntityRenderer.uv1.x + IrisEntityRenderer.uv2.x + IrisEntityRenderer.uv3.x) / 4.0f;
            float mid_v = (IrisEntityRenderer.uv0.y + IrisEntityRenderer.uv1.y + IrisEntityRenderer.uv2.y + IrisEntityRenderer.uv3.y) / 4.0f;
            long midUV = Int2.pack((int)Float.floatToRawIntBits(mid_u), (int)Float.floatToRawIntBits(mid_v));
            int tangent = Flerovium.config.skipEntityTangentCompute ? -1 : IrisEntityRenderer.computeTangent(packedNormal, positions, CUBE_VERTEX_XY, CUBE_VERTEX_ZW);
            int position = positions[elementOffset + 0];
            IrisEntityVertex.write(ptr, CUBE_VERTEX_XY[position], CUBE_VERTEX_ZW[position], textures[elementOffset + 0], packedOverlayLight, packedNormal, midUV, tangent);
            position = positions[elementOffset + 1];
            IrisEntityVertex.write(ptr += (long)IrisEntityVertex.STRIDE, CUBE_VERTEX_XY[position], CUBE_VERTEX_ZW[position], textures[elementOffset + 1], packedOverlayLight, packedNormal, midUV, tangent);
            position = positions[elementOffset + 2];
            IrisEntityVertex.write(ptr += (long)IrisEntityVertex.STRIDE, CUBE_VERTEX_XY[position], CUBE_VERTEX_ZW[position], textures[elementOffset + 2], packedOverlayLight, packedNormal, midUV, tangent);
            position = positions[elementOffset + 3];
            IrisEntityVertex.write(ptr += (long)IrisEntityVertex.STRIDE, CUBE_VERTEX_XY[position], CUBE_VERTEX_ZW[position], textures[elementOffset + 3], packedOverlayLight, packedNormal, midUV, tangent);
            ptr += (long)IrisEntityVertex.STRIDE;
            vertexCount += 4;
        }
        return vertexCount;
    }

    private static void unpackUV(long uv, Vector2f out) {
        out.x = Float.intBitsToFloat((int)(uv & 0xFFFFFFFFL));
        out.y = Float.intBitsToFloat((int)(uv >> 32 & 0xFFFFFFFFL));
    }

    private static int computeTangent(int packedNormal, int[] positions, long[] CUBE_VERTEX_XY, long[] CUBE_VERTEX_ZW) {
        float unpackedX = NormI8.unpackX((int)packedNormal);
        float unpackedY = NormI8.unpackY((int)packedNormal);
        float unpackedZ = NormI8.unpackZ((int)packedNormal);
        float pos0x = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[0]] & 0xFFFFFFFFL));
        float pos0y = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[0]] >> 32 & 0xFFFFFFFFL));
        float pos0z = Float.intBitsToFloat((int)(CUBE_VERTEX_ZW[positions[0]] & 0xFFFFFFFFL));
        float pos1x = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[1]] & 0xFFFFFFFFL));
        float pos1y = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[1]] >> 32 & 0xFFFFFFFFL));
        float pos1z = Float.intBitsToFloat((int)(CUBE_VERTEX_ZW[positions[1]] & 0xFFFFFFFFL));
        float pos2x = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[2]] & 0xFFFFFFFFL));
        float pos2y = Float.intBitsToFloat((int)(CUBE_VERTEX_XY[positions[2]] >> 32 & 0xFFFFFFFFL));
        float pos2z = Float.intBitsToFloat((int)(CUBE_VERTEX_ZW[positions[2]] & 0xFFFFFFFFL));
        return NormalHelper.computeTangent((float)unpackedX, (float)unpackedY, (float)unpackedZ, (float)pos0x, (float)pos0y, (float)pos0z, (float)IrisEntityRenderer.uv0.x, (float)IrisEntityRenderer.uv0.y, (float)pos1x, (float)pos1y, (float)pos1z, (float)IrisEntityRenderer.uv1.x, (float)IrisEntityRenderer.uv1.y, (float)pos2x, (float)pos2y, (float)pos2z, (float)IrisEntityRenderer.uv2.x, (float)IrisEntityRenderer.uv2.y);
    }
}

