/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.common.block;

import ianm1647.expandeddelight.common.registry.EDBlocks;
import ianm1647.expandeddelight.common.tag.EDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MilkCaskBlock
extends Block {
    public static IntegerProperty FERMENTING = IntegerProperty.create((String)"cheese_fermenting", (int)0, (int)7);

    public MilkCaskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)FERMENTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FERMENTING});
        super.createBlockStateDefinition(builder);
    }

    public int getMaxFermentingStage() {
        return 7;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            float chance = 0.0f;
            boolean hasWater = false;
            int maxLight = 0;
            for (BlockPos neighborPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                BlockState neighborState = level.getBlockState(neighborPos);
                if (!neighborState.is(EDTags.MILK_ACTIVATORS)) continue;
                chance += 0.02f;
            }
            chance += maxLight < 5 ? 0.1f : 0.05f;
            chance += hasWater ? 0.1f : 0.0f;
            if (level.getRandom().nextFloat() <= chance) {
                if (((Integer)state.getValue((Property)FERMENTING)).intValue() == this.getMaxFermentingStage()) {
                    if (this == EDBlocks.MILK_CASK.get()) {
                        level.setBlock(pos, EDBlocks.CHEESE_CASK.get().defaultBlockState(), 3);
                        level.playSound(null, pos, SoundEvents.SLIME_SQUISH_SMALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (this == EDBlocks.GOAT_MILK_CASK.get()) {
                        level.setBlock(pos, EDBlocks.GOAT_CHEESE_CASK.get().defaultBlockState(), 3);
                        level.playSound(null, pos, SoundEvents.SLIME_SQUISH_SMALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)FERMENTING, (Comparable)Integer.valueOf((Integer)state.getValue((Property)FERMENTING) + 1)), 3);
                }
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxFermentingStage() + 1 - (Integer)blockState.getValue((Property)FERMENTING);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.EGG_CRACK, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + 1.1, (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

