/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayRenderer;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayVisual
extends KineticBlockEntityVisual<WalkwayBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance leftShaft;
    private final RotatingInstance rightShaft;
    private final RotatingInstance bottomShaft;
    private final OrientedInstance backStep;
    private final OrientedInstance frontStep;
    private DyeColor color;

    public WalkwayVisual(VisualizationContext ctx, WalkwayBlockEntity blockEntity, float partialTick) {
        super(ctx, (KineticBlockEntity)blockEntity, partialTick);
        KineticBlock kinetic = (KineticBlock)this.blockState.getBlock();
        WalkwayBlock walkway = (WalkwayBlock)this.blockState.getBlock();
        Level level = ((WalkwayBlockEntity)this.blockEntity).getLevel();
        Direction left = Direction.fromAxisAndDirection((Direction.Axis)kinetic.getRotationAxis(this.blockState), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction right = left.getOpposite();
        this.leftShaft = kinetic.hasShaftTowards((LevelReader)level, this.pos, this.blockState, left) ? (RotatingInstance)this.getShaftInstancer(left).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.leftShaft.setPosition((Vec3i)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, left.getAxis());
        this.rightShaft = kinetic.hasShaftTowards((LevelReader)level, this.pos, this.blockState, right) ? (RotatingInstance)this.getShaftInstancer(right).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.rightShaft.setPosition((Vec3i)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, right.getAxis());
        this.bottomShaft = kinetic.hasShaftTowards((LevelReader)level, this.pos, this.blockState, Direction.DOWN) ? (RotatingInstance)this.getShaftInstancer(Direction.DOWN).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.bottomShaft.setPosition((Vec3i)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, Direction.Axis.Y);
        boolean isTerminal = walkway.getWalkwaySlope(this.blockState) == WalkwaySlope.TERMINAL;
        boolean isController = ((WalkwayBlockEntity)this.blockEntity).isController();
        Direction facing = this.getFacing();
        BlockPos pos1 = this.getVisualPosition();
        this.color = ((WalkwayBlockEntity)this.blockEntity).getColor();
        PartialModel model = this.getStepModel();
        if (isTerminal) {
            boolean flag = facing == Direction.NORTH || facing == Direction.EAST;
            Direction direction = facing = isController ? facing.getOpposite() : facing;
            if (flag) {
                this.backStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).createInstance();
                this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false)).setChanged();
                this.frontStep = (OrientedInstance)this.getEmptyStepInstancer().createInstance();
            } else {
                this.frontStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).createInstance();
                this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true)).setChanged();
                this.backStep = (OrientedInstance)this.getEmptyStepInstancer().createInstance();
            }
        } else {
            this.frontStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).createInstance();
            this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true)).setChanged();
            this.backStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).createInstance();
            this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false)).setChanged();
        }
    }

    private Instancer<RotatingInstance> getShaftInstancer(Direction dir) {
        return this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF, (Direction)dir));
    }

    private Instancer<RotatingInstance> getEmptyShaftInstancer() {
        return this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.block((BlockState)Blocks.AIR.defaultBlockState()));
    }

    private Instancer<OrientedInstance> getStepInstancer(Model model) {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, model);
    }

    private Instancer<OrientedInstance> getEmptyStepInstancer() {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)Blocks.AIR.defaultBlockState()));
    }

    private void updateSteps() {
        WalkwayBlock walkway = (WalkwayBlock)this.blockState.getBlock();
        boolean isTerminal = walkway.getWalkwaySlope(this.blockState) == WalkwaySlope.TERMINAL;
        boolean isController = ((WalkwayBlockEntity)this.blockEntity).isController();
        Direction facing = this.getFacing();
        PartialModel model = this.getStepModel();
        if (isTerminal) {
            boolean flag = facing == Direction.NORTH || facing == Direction.EAST;
            Direction direction = facing = isController ? facing.getOpposite() : facing;
            if (flag) {
                this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).stealInstance((Instance)this.backStep);
                this.getEmptyStepInstancer().stealInstance((Instance)this.frontStep);
            } else {
                this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).stealInstance((Instance)this.frontStep);
                this.getEmptyStepInstancer().stealInstance((Instance)this.backStep);
            }
        } else {
            this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).stealInstance((Instance)this.frontStep);
            this.getStepInstancer(Models.partial((PartialModel)model, (Direction)facing)).stealInstance((Instance)this.backStep);
        }
        this.frontStep.setChanged();
        this.backStep.setChanged();
    }

    public void _delete() {
        this.leftShaft.delete();
        this.rightShaft.delete();
        this.bottomShaft.delete();
        this.backStep.delete();
        this.frontStep.delete();
    }

    protected Direction getFacing() {
        return ((WalkwayBlock)this.blockState.getBlock()).getFacing(this.blockState);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        Direction facing = this.getFacing();
        BlockPos pos = this.getVisualPosition();
        this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, true)).setChanged();
        this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, false)).setChanged();
    }

    public void update(float partialTick) {
        super.update(partialTick);
        KineticBlock kinetic = (KineticBlock)this.blockState.getBlock();
        Direction.Axis axis = kinetic.getRotationAxis(this.blockState);
        if (((WalkwayBlockEntity)this.blockEntity).getColor() != this.color || ((WalkwayBlockEntity)this.blockEntity).resetClientRender) {
            this.color = ((WalkwayBlockEntity)this.blockEntity).getColor();
            ((WalkwayBlockEntity)this.blockEntity).resetClientRender = false;
            this.updateSteps();
        }
        this.leftShaft.setup((KineticBlockEntity)this.blockEntity, axis).setChanged();
        this.rightShaft.setup((KineticBlockEntity)this.blockEntity, axis).setChanged();
        this.bottomShaft.setup((KineticBlockEntity)this.blockEntity, Direction.Axis.Y).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.leftShaft});
        this.relight(this.pos, new FlatLit[]{this.rightShaft});
        this.relight(this.pos, new FlatLit[]{this.bottomShaft});
        this.relight(this.pos, new FlatLit[]{this.backStep});
        this.relight(this.pos, new FlatLit[]{this.frontStep});
    }

    protected PartialModel getStepModel() {
        return WalkwayRenderer.baseGetStepModel((WalkwayBlockEntity)this.blockEntity);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.leftShaft);
        consumer.accept((Instance)this.rightShaft);
        consumer.accept((Instance)this.bottomShaft);
        consumer.accept((Instance)this.frontStep);
        consumer.accept((Instance)this.backStep);
    }
}

