/*
 * Decompiled with CFR 0.152.
 */
package concerrox.emixx.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import concerrox.emixx.content.Layout;
import concerrox.emixx.content.StackManager;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.StackBatcher;
import java.util.List;
import java.util.function.Supplier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EmiScreenManager.ScreenSpace.class}, remap=false)
public abstract class EmiScreenManagerScreenSpaceMixin {
    @Shadow
    @Final
    public int pageSize;
    @Shadow
    @Final
    public StackBatcher batcher;
    @Shadow
    @Final
    public int th;
    @Shadow
    @Final
    public int tw;

    @Shadow
    public abstract List<? extends EmiIngredient> getStacks();

    @Shadow
    public abstract int getRawOffsetFromMouse(int var1, int var2);

    @Shadow
    public abstract int getRawX(int var1);

    @Shadow
    public abstract int getRawY(int var1);

    @Shadow
    public abstract int getWidth(int var1);

    @Shadow
    public abstract int getX(int var1, int var2);

    @Shadow
    public abstract int getY(int var1, int var2);

    @Shadow
    public abstract SidebarType getType();

    @Inject(method={"<init>(IIIIZLjava/util/List;Ljava/util/function/Supplier;Z)V"}, at={@At(value="TAIL")})
    private void createGrid(int tx, int ty, int tw, int th, boolean rtl, List<Bounds> exclusion, Supplier<SidebarType> typeSupplier, boolean search, CallbackInfo ci) {
        if (this.getType() == SidebarType.INDEX) {
            StackManager.INSTANCE.setStackGrid$emixx_common(new EmiStack[th + 9][tw + 9]);
        }
    }

    @Overwrite
    public void render(EmiDrawContext context, int mouseX, int mouseY, float delta, int startIndex) {
        if (startIndex != Layout.INSTANCE.getStartIndex()) {
            Layout.INSTANCE.setStartIndex(startIndex);
            Layout.INSTANCE.setTextureDirty(true);
            Layout.INSTANCE.setClean(false);
        }
        if (this.pageSize > 0) {
            RenderSystem.enableDepthTest();
            EmiPort.setPositionTexShader();
            context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.batcher.begin(0, 0, 0);
            int i = startIndex;
            List<? extends EmiIngredient> stacks = this.getStacks();
            int hovered = this.getRawOffsetFromMouse(mouseX, mouseY);
            if (hovered != -1 && EmiConfig.showHoverOverlay && startIndex + hovered < stacks.size()) {
                int hx = this.getRawX(hovered);
                int hy = this.getRawY(hovered);
                EmiRenderHelper.drawSlotHightlight((EmiDrawContext)context, (int)hx, (int)hy, (int)18, (int)18, (int)0);
            }
            context.push();
            block0: for (int yo = 0; yo < this.th; ++yo) {
                for (int xo = 0; xo < this.getWidth(yo); ++xo) {
                    if (i >= stacks.size()) break block0;
                    int cx = this.getX(xo, yo);
                    int cy = this.getY(xo, yo);
                    EmiIngredient stack = stacks.get(i++);
                    if (this.getType() == SidebarType.INDEX && !Layout.INSTANCE.isClean()) {
                        StackManager.INSTANCE.getStackGrid$emixx_common()[yo][xo] = (EmiStack)stack;
                    }
                    this.batcher.render(stack, context.raw(), cx + 1, cy + 1, delta);
                    if (this.getType() != SidebarType.INDEX) continue;
                    if (EmiConfig.editMode && EmiHidden.isHidden((EmiIngredient)stack)) {
                        RenderSystem.enableDepthTest();
                        context.fill(cx, cy, 18, 18, 0x33FF0000);
                        continue;
                    }
                    if (!EmiConfig.highlightDefaulted || BoM.getRecipe((EmiIngredient)stack) == null) continue;
                    RenderSystem.enableDepthTest();
                    context.fill(cx, cy, 18, 18, 0x3300FF00);
                }
            }
            this.batcher.draw();
            context.pop();
            if (this.getType() == SidebarType.INDEX) {
                Layout.INSTANCE.buildLayoutTiles((EmiScreenManager.ScreenSpace)EmiScreenManager.ScreenSpace.class.cast(this), context);
            }
        }
    }
}

