/*
 * Decompiled with CFR 0.152.
 */
package concerrox.emixx.content.stackgroup.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import concerrox.emixx.EmiPlusPlus;
import concerrox.emixx.content.stackgroup.data.StackGroup;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lconcerrox/emixx/content/stackgroup/data/EmiStackGroup;", "Lconcerrox/emixx/content/stackgroup/data/StackGroup;", "Lnet/minecraft/resources/ResourceLocation;", "id", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "targets", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;)V", "Lcom/google/gson/JsonElement;", "serialize", "()Lcom/google/gson/JsonElement;", "stack", "", "match", "(Ldev/emi/emi/api/stack/EmiIngredient;)Z", "Ljava/util/Set;", "getTargets", "()Ljava/util/Set;", "Companion", "emixx-common"})
@SourceDebugExtension(value={"SMAP\nEmiStackGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmiStackGroup.kt\nconcerrox/emixx/content/stackgroup/data/EmiStackGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1761#2,3:83\n*S KotlinDebug\n*F\n+ 1 EmiStackGroup.kt\nconcerrox/emixx/content/stackgroup/data/EmiStackGroup\n*L\n79#1:83,3\n*E\n"})
public final class EmiStackGroup
extends StackGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<EmiIngredient> targets;

    public EmiStackGroup(@NotNull ResourceLocation id, @NotNull Set<? extends EmiIngredient> targets) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(id);
        this.targets = targets;
    }

    @NotNull
    public final Set<EmiIngredient> getTargets() {
        return this.targets;
    }

    @NotNull
    public final JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getId().toString());
        JsonArray contents = new JsonArray();
        for (EmiIngredient ingredient : this.targets) {
            contents.add(EmiIngredientSerializer.getSerialized((EmiIngredient)ingredient));
        }
        json.add("contents", (JsonElement)contents);
        return (JsonElement)json;
    }

    @Override
    public boolean match(@NotNull EmiIngredient stack) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Iterable $this$any$iv = this.targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EmiIngredient it = (EmiIngredient)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)stack)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00020\b\"\u0004\b\u0000\u0010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lconcerrox/emixx/content/stackgroup/data/EmiStackGroup$Companion;", "", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/nio/file/Path;", "fileName", "Lconcerrox/emixx/content/stackgroup/data/EmiStackGroup;", "parse", "(Lcom/google/gson/JsonElement;Ljava/nio/file/Path;)Lconcerrox/emixx/content/stackgroup/data/EmiStackGroup;", "T", "Lnet/minecraft/tags/TagKey;", "tag", "of", "(Lnet/minecraft/tags/TagKey;)Lconcerrox/emixx/content/stackgroup/data/EmiStackGroup;", "emixx-common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EmiStackGroup parse(@NotNull JsonElement json, @NotNull Path fileName) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            try {
                EmiIngredient ingredient;
                JsonElement element;
                if (!(json instanceof JsonObject)) {
                    throw new Exception("Not a JSON object");
                }
                if (!GsonHelper.isStringValue((JsonObject)((JsonObject)json), (String)"id")) {
                    throw new Exception("ID is either not present or not a string");
                }
                ResourceLocation id = ResourceLocation.parse((String)((JsonObject)json).get("id").getAsString());
                if (!GsonHelper.isArrayNode((JsonObject)((JsonObject)json), (String)"contents")) {
                    throw new Exception("Contents are either not present or not a list");
                }
                HashSet hashSet = Sets.newHashSet();
                Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
                Set targets = hashSet;
                Iterator iterator = ((JsonObject)json).getAsJsonArray("contents").iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    element = (JsonElement)iterator2.next();
                    ingredient = EmiIngredientSerializer.getDeserialized((JsonElement)element);
                    Intrinsics.checkNotNull((Object)ingredient);
                    targets.add(ingredient);
                    List list = ingredient.getEmiStacks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEmiStacks(...)");
                    targets.addAll(list);
                }
                if (GsonHelper.isArrayNode((JsonObject)((JsonObject)json), (String)"exclusions")) {
                    Iterator iterator3 = ((JsonObject)json).getAsJsonArray("exclusions").iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
                    iterator2 = iterator3;
                    while (iterator2.hasNext()) {
                        element = (JsonElement)iterator2.next();
                        ingredient = EmiIngredientSerializer.getDeserialized((JsonElement)element);
                        targets.remove(ingredient);
                        List list = ingredient.getEmiStacks();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEmiStacks(...)");
                        targets.removeAll(list);
                    }
                }
                Intrinsics.checkNotNull((Object)id);
                return new EmiStackGroup(id, targets);
            }
            catch (Exception e) {
                EmiPlusPlus.INSTANCE.getLOGGER$emixx_common().error("Failed to parse {}: {}", (Object)fileName, (Object)e);
                return null;
            }
        }

        @NotNull
        public final <T> EmiStackGroup of(@NotNull TagKey<T> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Set targets = new LinkedHashSet();
            EmiIngredient ingredient = EmiIngredient.of(tag);
            Intrinsics.checkNotNull((Object)ingredient);
            targets.add(ingredient);
            List list = ingredient.getEmiStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEmiStacks(...)");
            targets.addAll(list);
            ResourceLocation resourceLocation = tag.location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return new EmiStackGroup(resourceLocation, targets);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

