/*
 * Decompiled with CFR 0.152.
 */
package com.emiforcreatestock;

import com.emiforcreatestock.EMIForCreateStockConfig;
import com.emiforcreatestock.ForMoreParameters;
import com.emiforcreatestock.Mixin.CategoryEntryMixin;
import com.emiforcreatestock.Mixin.StockKeeperRequestScreenMixin;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StockRequestHandler
implements StandardRecipeHandler<StockKeeperRequestMenu> {
    protected static final List<Slot> CRAFTING_SLOTS = List.of();

    public List<Slot> getInputSources(StockKeeperRequestMenu menu) {
        return menu.slots;
    }

    public List<Slot> getCraftingSlots(StockKeeperRequestMenu menu) {
        return CRAFTING_SLOTS;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<StockKeeperRequestMenu> context) {
        AbstractContainerScreen abstractContainerScreen = context.getScreen();
        if (abstractContainerScreen instanceof StockKeeperRequestScreen) {
            StockKeeperRequestScreen screen = (StockKeeperRequestScreen)abstractContainerScreen;
            return this.enoughIngredients(recipe, screen, context.getAmount(), context.getInventory(), null);
        }
        return false;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<StockKeeperRequestMenu> context) {
        AbstractContainerScreen abstractContainerScreen = context.getScreen();
        if (abstractContainerScreen instanceof StockKeeperRequestScreen) {
            StockKeeperRequestScreen screen = (StockKeeperRequestScreen)abstractContainerScreen;
            ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
            if (!this.enoughIngredients(recipe, screen, context.getAmount(), context.getInventory(), (TriConsumer<EmiStack, Long, BigItemStack>)((TriConsumer)(ignore, amount, stack) -> {
                if (amount <= 0L || stack == null) {
                    return;
                }
                Optional<BigItemStack> optional = stacks.stream().filter(bigItemStack -> ItemStack.isSameItemSameComponents((ItemStack)bigItemStack.stack, (ItemStack)stack.stack)).findFirst();
                if (optional.isPresent()) {
                    optional.get().count = Math.toIntExact(amount);
                } else {
                    stacks.add(new BigItemStack(stack.stack, Math.toIntExact(amount)));
                }
            }))) {
                return false;
            }
            this.moveItems(recipe, screen, stacks);
            return true;
        }
        return super.craft(recipe, context);
    }

    protected boolean searchOutput(int requiredAmount, EmiPlayerInventory playerInventory, StockKeeperRequestScreen screen, EmiIngredient ingredient, @Nullable @Nullable TriConsumer<EmiStack, Long, @Nullable BigItemStack> action, boolean findSome) {
        if (ForMoreParameters.playerNeedCount != -1L) {
            for (EmiStack stack : ingredient.getEmiStacks()) {
                if (!this.searchSingleStack(requiredAmount, playerInventory, screen, action, findSome, stack, ForMoreParameters.playerNeedCount)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean enoughIngredients(int requiredAmount, EmiPlayerInventory playerInventory, StockKeeperRequestScreen screen, EmiIngredient ingredient, @Nullable @Nullable TriConsumer<EmiStack, Long, @Nullable BigItemStack> action, boolean findSome) {
        if (ingredient.isEmpty()) {
            return true;
        }
        Iterator iterator = ingredient.getEmiStacks().iterator();
        if (iterator.hasNext()) {
            EmiStack stack = (EmiStack)iterator.next();
            long amount = ingredient.getAmount() * (long)requiredAmount;
            return this.searchSingleStack(requiredAmount, playerInventory, screen, action, findSome, stack, amount);
        }
        return requiredAmount == Integer.MAX_VALUE;
    }

    protected boolean searchSingleStack(int requiredAmount, EmiPlayerInventory playerInventory, StockKeeperRequestScreen screen, @Nullable @Nullable TriConsumer<EmiStack, Long, @Nullable BigItemStack> action, boolean findSome, EmiStack stack, long amount) {
        if (requiredAmount < Integer.MAX_VALUE && playerInventory.inventory.containsKey(stack)) {
            long playerCount = ((EmiStack)playerInventory.inventory.get(stack)).getAmount();
            if (amount <= playerCount) {
                if (action != null) {
                    action.accept((Object)stack, (Object)amount, null);
                }
                return true;
            }
            amount -= playerCount;
            if (findSome && action != null) {
                action.accept((Object)stack, (Object)playerCount, null);
            }
        }
        for (List<BigItemStack> items : StockRequestHandler.getItemSource(screen)) {
            Optional<BigItemStack> optional = items.stream().filter(bigItemStack -> bigItemStack.stack.is(stack.getItemStack().getItem())).findFirst();
            if (!optional.isPresent()) continue;
            BigItemStack bigItemStack2 = optional.get();
            if ((long)bigItemStack2.count >= amount) {
                if (action != null) {
                    action.accept((Object)stack, (Object)amount, (Object)bigItemStack2);
                }
                return true;
            }
            if (requiredAmount == Integer.MAX_VALUE) {
                if (action == null) continue;
                action.accept((Object)stack, (Object)Math.min((long)bigItemStack2.stack.getMaxStackSize() * 9L, amount), (Object)bigItemStack2);
                continue;
            }
            if (!findSome || action == null) break;
            action.accept((Object)stack, (Object)bigItemStack2.count, (Object)bigItemStack2);
            break;
        }
        return requiredAmount == Integer.MAX_VALUE;
    }

    @NotNull
    public static List<List<BigItemStack>> getItemSource(StockKeeperRequestScreen screen) {
        return screen.currentItemSource == null ? new ArrayList() : screen.currentItemSource;
    }

    protected boolean enoughIngredients(EmiRecipe recipe, StockKeeperRequestScreen screen, int craftTimes, EmiPlayerInventory playerInventory, @Nullable @Nullable TriConsumer<EmiStack, Long, @Nullable BigItemStack> action) {
        HashMap<EmiIngredient, Integer> foundIngredients = new HashMap<EmiIngredient, Integer>();
        List outputs = recipe.getOutputs();
        if (!outputs.isEmpty() && this.searchOutput(craftTimes, playerInventory, screen, (EmiIngredient)outputs.getFirst(), (TriConsumer<EmiStack, Long, BigItemStack>)((TriConsumer)(emiStack, amount, bigItemStack) -> {
            if (amount >= 0L) {
                foundIngredients.compute((EmiIngredient)outputs.getFirst(), (ingredient, count) -> count == null ? Math.toIntExact(amount) : count + Math.toIntExact(amount));
                if (action != null) {
                    action.accept(emiStack, amount, bigItemStack);
                }
            }
        }), true)) {
            return true;
        }
        for (EmiIngredient ingredient : recipe.getInputs()) {
            Optional<Map.Entry> foundIngredient = foundIngredients.entrySet().stream().filter(entry -> EmiIngredient.areEqual((EmiIngredient)ingredient, (EmiIngredient)((EmiIngredient)entry.getKey()))).findFirst();
            int count = Math.toIntExact(ingredient.getAmount() * (long)craftTimes);
            boolean present = foundIngredient.isPresent();
            if (present) {
                count += ((Integer)foundIngredient.get().getValue()).intValue();
            }
            if (!this.enoughIngredients(count, playerInventory, screen, ingredient, action, false)) {
                return false;
            }
            foundIngredients.put(present ? (EmiIngredient)foundIngredient.get().getKey() : ingredient, count);
        }
        return true;
    }

    protected void clearRecipe(@NotNull StockKeeperRequestScreen screen) {
        screen.itemsToOrder.clear();
    }

    protected void sendRequest(@NotNull StockKeeperRequestScreen screen, @Nullable String address) {
        String oldAddress = screen.addressBox.getValue();
        if (address != null) {
            screen.addressBox.setValue(address);
        }
        if (!EMIForCreateStockConfig.sendIt()) {
            return;
        }
        ((StockKeeperRequestScreenMixin)screen).emiforcreatestock$sendIt();
        screen.addressBox.setValue(oldAddress);
    }

    protected void moveItems(EmiRecipe recipe, @NotNull StockKeeperRequestScreen screen, @NotNull List<BigItemStack> stacks) {
        this.clearRecipe(screen);
        stacks.stream().filter(stack -> recipe.getOutputs().stream().anyMatch(output -> ItemStack.isSameItem((ItemStack)output.getItemStack(), (ItemStack)stack.stack))).forEach(stack -> screen.itemsToOrder.add(stack));
        if (!screen.itemsToOrder.isEmpty()) {
            stacks.removeAll(screen.itemsToOrder);
            this.sendRequest(screen, null);
        }
        for (BigItemStack stack2 : stacks) {
            if (screen.itemsToOrder.size() < 9) {
                screen.itemsToOrder.add(stack2);
            }
            if (screen.itemsToOrder.size() < 9) continue;
            this.sendRequest(screen, this.getAddress(recipe, screen));
        }
        this.sendRequest(screen, this.getAddress(recipe, screen));
        if (!EMIForCreateStockConfig.sendIt()) {
            List<List<BigItemStack>> itemSource = StockRequestHandler.getItemSource(screen);
            screen.itemsToOrder.forEach(stack -> {
                for (List items : itemSource) {
                    items.stream().filter(bigItemStack -> bigItemStack.stack.is(stack.stack.getItem())).findFirst().ifPresent(bigItemStack -> bigItemStack.count -= stack.count);
                }
            });
        }
    }

    @Nullable
    public String getAddress(EmiRecipe recipe, StockKeeperRequestScreen screen) {
        for (EmiStack output : recipe.getOutputs()) {
            for (int ordinary = 0; ordinary < screen.categories.size(); ++ordinary) {
                if (!StockRequestHandler.getItemSource(screen).get(ordinary).stream().anyMatch(stack -> {
                    if (stack.stack.getItem() instanceof FilterItem) {
                        FilterItemStack filter = FilterItemStack.of((ItemStack)stack.stack);
                        return filter.test((Level)screen.getMinecraft().level, output.getItemStack());
                    }
                    return false;
                })) continue;
                return StockRequestHandler.getAvailableAddress(((CategoryEntryMixin)screen.categories.get(ordinary)).getName());
            }
        }
        return null;
    }

    @Nullable
    public static String getAvailableAddress(String categoryName) {
        if (StockRequestHandler.forAddress(categoryName)) {
            return categoryName.substring(1);
        }
        return null;
    }

    public static boolean forAddress(String categoryName) {
        return categoryName.startsWith("#");
    }

    public void render(EmiRecipe recipe, EmiCraftContext<StockKeeperRequestMenu> context, List<Widget> widgets, GuiGraphics draw) {
        AbstractContainerScreen abstractContainerScreen = context.getScreen();
        if (abstractContainerScreen instanceof StockKeeperRequestScreen) {
            StockKeeperRequestScreen screen = (StockKeeperRequestScreen)abstractContainerScreen;
            StandardRecipeHandler.renderMissing((EmiRecipe)recipe, (EmiPlayerInventory)new PlayerInventoryAndStock(context.getInventory(), screen), widgets, (GuiGraphics)draw);
        } else {
            super.render(recipe, context, widgets, draw);
        }
    }

    private class PlayerInventoryAndStock
    extends EmiPlayerInventory {
        @NotNull
        public final EmiPlayerInventory playerInventory;
        @NotNull
        public final StockKeeperRequestScreen screen;

        @Deprecated
        private PlayerInventoryAndStock(Player entity) throws IllegalAccessException {
            super(entity);
            throw new IllegalAccessException("Illegal access to PlayerInventoryAndStock constructor!");
        }

        public PlayerInventoryAndStock(@NotNull EmiPlayerInventory playerInventory, StockKeeperRequestScreen screen) {
            super(List.of());
            this.inventory = playerInventory.inventory;
            this.playerInventory = playerInventory;
            this.screen = screen;
        }

        public List<Boolean> getCraftAvailability(EmiRecipe recipe) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            recipe.getInputs().forEach(ingredient -> list.add(StockRequestHandler.this.enoughIngredients(1, this.playerInventory, this.screen, (EmiIngredient)ingredient, null, false)));
            return list;
        }

        public Predicate<EmiRecipe> getPredicate() {
            return this.playerInventory.getPredicate();
        }

        public List<EmiIngredient> getCraftables() {
            return this.playerInventory.getCraftables();
        }

        public boolean canCraft(EmiRecipe recipe, long amount) {
            for (EmiIngredient ingredient : recipe.getInputs()) {
                if (StockRequestHandler.this.enoughIngredients((int)amount, this.playerInventory, this.screen, ingredient, null, false)) continue;
                return false;
            }
            return true;
        }

        public boolean isEqual(EmiPlayerInventory other) {
            if (other instanceof PlayerInventoryAndStock) {
                PlayerInventoryAndStock playerInventoryAndStock = (PlayerInventoryAndStock)other;
                return this.playerInventory.equals(playerInventoryAndStock.playerInventory) && this.screen.equals(playerInventoryAndStock.screen);
            }
            return false;
        }
    }
}

