/*
 * Decompiled with CFR 0.152.
 */
package com.emiforcreatestock;

import com.emiforcreatestock.Mixin.StockTickerBlockEntityMixin;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StockCloneBehaviour
extends BlockEntityBehaviour
implements ClipboardCloneable {
    public static final String KEY = "StockCloneBehaviour";
    public static final BehaviourType<StockCloneBehaviour> TYPE = new BehaviourType();
    private static final Map<FilterItem, Integer> FILTERS = new HashMap<FilterItem, Integer>();

    public StockCloneBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public String getClipboardKey() {
        return KEY;
    }

    public boolean writeToClipboard(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag tag, Direction direction) {
        CompoundTag nbt = new CompoundTag();
        this.getBlockEntity().saveAdditional(nbt, provider);
        tag.put(KEY, (Tag)Objects.requireNonNull(nbt));
        return true;
    }

    public boolean readFromClipboard(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag tag, Player player, Direction direction, boolean simulate) {
        if (this.legalBlockEntity() && tag.contains(KEY)) {
            List stacks = NBTHelper.readItemList((ListTag)((ListTag)tag.getCompound(KEY).get("Categories")), (HolderLookup.Provider)provider);
            List<Item> items = stacks.stream().map(ItemStack::getItem).toList();
            Map<FilterItem, Integer> needFilters = StockCloneBehaviour.getFilters();
            Inventory inventory = player.getInventory();
            needFilters.forEach((filterItem, integer) -> needFilters.replace((FilterItem)filterItem, Math.toIntExact(items.stream().filter(filterItem::equals).count())));
            if (this.checkEnoughFilterItem(player, inventory, needFilters)) {
                if (!simulate) {
                    this.getBlockEntity().loadCustomOnly(tag.getCompound(KEY), provider);
                    this.getBlockEntity().notifyUpdate();
                    this.removeFilterItem(player, inventory, needFilters);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean legalBlockEntity() {
        StockTickerBlockEntityMixin entity = (StockTickerBlockEntityMixin)this.getBlockEntity();
        return entity.getActiveLinks() == 0 && entity.getLastClientsideStockSnapshot() == null && entity.getCategories().isEmpty();
    }

    protected boolean checkEnoughFilterItem(Player player, Inventory inventory, Map<FilterItem, Integer> needFilters) {
        if (player.isCreative()) {
            return true;
        }
        Map<FilterItem, Integer> existFilters = StockCloneBehaviour.getFilters();
        existFilters.forEach((filterItem, integer) -> existFilters.replace((FilterItem)filterItem, inventory.countItem((Item)filterItem)));
        boolean result = true;
        ArrayList<Integer> needCount = new ArrayList<Integer>(needFilters.values());
        ArrayList<Integer> existCount = new ArrayList<Integer>(existFilters.values());
        for (int index = 0; index < needCount.size(); ++index) {
            result &= (Integer)existCount.get(index) >= (Integer)needCount.get(index);
        }
        return result;
    }

    protected void removeFilterItem(Player player, Inventory inventory, Map<FilterItem, Integer> items) {
        if (player.isCreative()) {
            return;
        }
        items.forEach((filterItem, integer) -> {
            for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
                ItemStack stack = inventory.getItem(slot);
                if (stack.getItem() != filterItem) continue;
                if (stack.getCount() >= integer) {
                    stack.shrink(integer.intValue());
                    return;
                }
                integer = integer - stack.getCount();
                stack.setCount(0);
            }
        });
        inventory.setChanged();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public StockTickerBlockEntity getBlockEntity() {
        return (StockTickerBlockEntity)this.blockEntity;
    }

    public static Map<FilterItem, Integer> getFilters() {
        return new HashMap<FilterItem, Integer>(FILTERS);
    }

    static {
        List<Item> list = BuiltInRegistries.ITEM.stream().filter(FilterItem.class::isInstance).toList();
        list.forEach(item -> FILTERS.put((FilterItem)item, 0));
    }
}

