/*
 * Decompiled with CFR 0.152.
 */
package com.emiforcreatestock.Mixin;

import com.emiforcreatestock.StockCloneBehaviour;
import com.emiforcreatestock.StockRequestHandler;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StockTickerBlockEntity.class})
public interface StockTickerBlockEntityMixin {
    @Accessor(value="lastClientsideStockSnapshot")
    public List<List<BigItemStack>> getLastClientsideStockSnapshot();

    @Accessor(value="categories")
    public List<ItemStack> getCategories();

    @Accessor(value="activeLinks")
    public int getActiveLinks();

    @Mixin(value={StockTickerBlockEntity.class})
    public static abstract class StockTickerBlockEntityMixin_
    extends StockCheckingBlockEntity
    implements IHaveHoveringInformation {
        @Shadow
        protected List<ItemStack> categories;
        @Shadow
        protected List<List<BigItemStack>> lastClientsideStockSnapshot;

        public StockTickerBlockEntityMixin_(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Inject(method={"receiveStockPacket"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=2)})
        public void initCraftCategories(List<BigItemStack> stacks, boolean endOfTransmission, CallbackInfo ci) {
            for (int index = 0; index < this.categories.size(); ++index) {
                ItemStack filter = this.categories.get(index);
                if (filter.isEmpty() || !StockRequestHandler.forAddress(filter.getHoverName().getString())) continue;
                ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
                FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)filter);
                if (!filterItemStack.isFilterItem()) continue;
                inCategory.add(new BigItemStack(filterItemStack.item()));
                this.lastClientsideStockSnapshot.set(index, inCategory);
            }
        }

        @ModifyExpressionValue(method={"receiveStockPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
        public boolean test(boolean original, @Local ItemStack filter) {
            return original || StockRequestHandler.forAddress(filter.getHoverName().getString());
        }

        public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
            super.addBehaviours(behaviours);
            behaviours.add(new StockCloneBehaviour((SmartBlockEntity)this));
        }
    }
}

