/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.recipe;

import cc.abbie.emi_ores.EmiOres;
import cc.abbie.emi_ores.compat.emi.EmiOresRecipeCategories;
import cc.abbie.emi_ores.compat.emi.recipe.AbstractPlacedFeatureEmiRecipe;
import cc.abbie.emi_ores.compat.emi.stack.BiomeEmiStack;
import cc.abbie.emi_ores.mixin.accessor.BlockMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.BlockStateMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.CountPlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.HeightRangePlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.RandomBlockMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.RandomBlockStateMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.RarityFilterAccessor;
import cc.abbie.emi_ores.mixin.accessor.TagMatchTestAccessor;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ScatteredOreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class OreGenEmiRecipe
extends AbstractPlacedFeatureEmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final HeightProvider heightProvider;
    private final EmiIngredient biomes;
    private final float discardChanceOnAirExposure;
    private final int countMin;
    private final int countMax;
    private final int rarityChance;

    public OreGenEmiRecipe(PlacedFeature feature, ResourceLocation id) {
        this.id = id;
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        OreConfiguration oreConfig = (OreConfiguration)((ConfiguredFeature)feature.feature().value()).config();
        this.discardChanceOnAirExposure = oreConfig.discardChanceOnAirExposure;
        oreConfig.targetStates.forEach(targetBlockState -> {
            RuleTest target = targetBlockState.target;
            if (target instanceof TagMatchTest) {
                TagMatchTest tagMatchTest = (TagMatchTest)target;
                TagKey<Block> tag = ((TagMatchTestAccessor)tagMatchTest).getTag();
                List l = BuiltInRegistries.BLOCK.getOrCreateTag(tag).stream().map(Holder::value).map(EmiStack::of).collect(Collectors.toList());
                inputs.add(EmiIngredient.of(l));
            } else if (target instanceof BlockMatchTest) {
                BlockMatchTest blockMatchTest = (BlockMatchTest)target;
                Block block = ((BlockMatchTestAccessor)blockMatchTest).getBlock();
                inputs.add(EmiStack.of((ItemLike)block));
            } else if (target instanceof BlockStateMatchTest) {
                BlockStateMatchTest blockStateMatchTest = (BlockStateMatchTest)target;
                BlockState state = ((BlockStateMatchTestAccessor)blockStateMatchTest).getBlockState();
                inputs.add(EmiStack.of((ItemLike)state.getBlock()));
            } else if (target instanceof RandomBlockMatchTest) {
                RandomBlockMatchTest randomBlockMatchTest = (RandomBlockMatchTest)target;
                RandomBlockMatchTestAccessor accessor = (RandomBlockMatchTestAccessor)randomBlockMatchTest;
                Block block = accessor.getBlock();
                float probability = accessor.getProbability();
                inputs.add(EmiStack.of((ItemLike)block).setChance(probability));
            } else if (target instanceof RandomBlockStateMatchTest) {
                RandomBlockStateMatchTest randomBlockStateMatchTest = (RandomBlockStateMatchTest)target;
                RandomBlockStateMatchTestAccessor accessor = (RandomBlockStateMatchTestAccessor)randomBlockStateMatchTest;
                Block block = accessor.getBlockState().getBlock();
                float probability = accessor.getProbability();
                inputs.add(EmiStack.of((ItemLike)block).setChance(probability));
            } else {
                inputs.add(EmiStack.EMPTY);
            }
            outputs.add(EmiStack.of((ItemLike)targetBlockState.state.getBlock()).setAmount((long)oreConfig.size));
        });
        this.inputs = Collections.unmodifiableList(inputs);
        this.outputs = Collections.unmodifiableList(outputs);
        HeightProvider heightProvider = null;
        List<Object> biomes = List.of();
        int countMin = -1;
        int countMax = -1;
        int rarityChance = -1;
        for (PlacementModifier modifier : feature.placement()) {
            if (modifier instanceof HeightRangePlacement) {
                HeightRangePlacement heightRange = (HeightRangePlacement)modifier;
                heightProvider = ((HeightRangePlacementAccessor)heightRange).getHeight();
                continue;
            }
            if (modifier instanceof BiomeFilter) {
                biomes = OreGenEmiRecipe.getBiomes(id, feature);
                continue;
            }
            if (modifier instanceof CountPlacement) {
                CountPlacement countPlacement = (CountPlacement)modifier;
                IntProvider countIntProvider = ((CountPlacementAccessor)countPlacement).getCount();
                countMin = countIntProvider.getMinValue();
                countMax = countIntProvider.getMaxValue();
                continue;
            }
            if (!(modifier instanceof RarityFilter)) continue;
            RarityFilter rarityFilter = (RarityFilter)modifier;
            rarityChance = ((RarityFilterAccessor)rarityFilter).getChance();
        }
        if (((ConfiguredFeature)feature.feature().value()).feature() instanceof ScatteredOreFeature) {
            countMax = 1;
            countMin = 1;
        }
        this.countMin = countMin;
        this.countMax = countMax;
        this.rarityChance = rarityChance;
        this.heightProvider = heightProvider;
        this.biomes = EmiIngredient.of(biomes.stream().map(BiomeEmiStack::of).toList());
    }

    public EmiRecipeCategory getCategory() {
        return EmiOresRecipeCategories.OREGEN;
    }

    public ResourceLocation getId() {
        return EmiOres.id("/ore/" + this.id.getNamespace() + "/" + this.id.getPath());
    }

    public List<EmiIngredient> getInputs() {
        return Stream.concat(this.inputs.stream(), Stream.of(this.biomes)).toList();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return Math.max(54, 18 + 18 * this.inputs.size());
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        Component veinFreq;
        for (int i = 0; i < this.inputs.size(); ++i) {
            widgets.addSlot(this.inputs.get(i), 0, 18 + i * 18);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 18 + i * 18);
            widgets.addSlot((EmiIngredient)this.outputs.get(i), 46, 18 + i * 18).recipeContext((EmiRecipe)this);
        }
        OreGenEmiRecipe.addDistributionGraph(widgets, 64, 0, this.heightProvider);
        if (!this.biomes.isEmpty()) {
            widgets.addSlot(this.biomes, 96, 18);
        }
        if (this.discardChanceOnAirExposure > 0.0f) {
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)Items.BARRIER).setChance(this.discardChanceOnAirExposure), 142, 18).appendTooltip((Component)Component.translatable((String)"emi_ores.discard_on_air_chance"));
        }
        if ((veinFreq = OreGenEmiRecipe.getVeinFreqComponent(this.countMin, this.countMax, this.rarityChance)) != null) {
            widgets.addText(veinFreq, 160, 45, 0, false).horizontalAlign(TextWidget.Alignment.END).verticalAlign(TextWidget.Alignment.CENTER);
        }
    }
}

