/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.recipe;

import cc.abbie.emi_ores.EmiOres;
import cc.abbie.emi_ores.client.FeaturesReciever;
import cc.abbie.emi_ores.mixin.accessor.TrapezoidHeightAccessor;
import cc.abbie.emi_ores.mixin.accessor.UniformHeightAccessor;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public abstract class AbstractPlacedFeatureEmiRecipe
implements EmiRecipe {
    private static final ResourceLocation DISTRIBUTION = EmiOres.id("textures/gui/distribution.png");

    protected static Component anchorText(VerticalAnchor anchor) {
        Object s;
        if (anchor instanceof VerticalAnchor.Absolute) {
            VerticalAnchor.Absolute absolute = (VerticalAnchor.Absolute)anchor;
            s = String.valueOf(absolute.y());
        } else if (anchor instanceof VerticalAnchor.AboveBottom) {
            VerticalAnchor.AboveBottom aboveBottom = (VerticalAnchor.AboveBottom)anchor;
            int offset = aboveBottom.offset();
            s = offset == 0 ? "bot" : (offset > 0 ? "bot+" + offset : "bot" + offset);
        } else if (anchor instanceof VerticalAnchor.BelowTop) {
            VerticalAnchor.BelowTop belowTop = (VerticalAnchor.BelowTop)anchor;
            int offset = -belowTop.offset();
            s = offset == 0 ? "top" : (offset > 0 ? "top+" + offset : "top" + offset);
        } else {
            throw new RuntimeException();
        }
        return Component.literal((String)s);
    }

    protected static Component anchorTextLong(VerticalAnchor anchor) {
        return AbstractPlacedFeatureEmiRecipe.anchorTextLongInner(anchor).withStyle(ChatFormatting.WHITE);
    }

    private static MutableComponent anchorTextLongInner(VerticalAnchor anchor) {
        if (anchor instanceof VerticalAnchor.Absolute) {
            VerticalAnchor.Absolute absolute = (VerticalAnchor.Absolute)anchor;
            return Component.literal((String)String.valueOf(absolute.y()));
        }
        if (anchor instanceof VerticalAnchor.AboveBottom) {
            VerticalAnchor.AboveBottom aboveBottom = (VerticalAnchor.AboveBottom)anchor;
            int offset = aboveBottom.offset();
            if (offset == 0) {
                return Component.translatable((String)"emi_ores.distribution.anchor.bottom");
            }
            if (offset > 0) {
                return Component.translatable((String)"emi_ores.distribution.anchor.above_bottom", (Object[])new Object[]{offset});
            }
            return Component.translatable((String)"emi_ores.distribution.anchor.below_bottom", (Object[])new Object[]{-offset});
        }
        if (anchor instanceof VerticalAnchor.BelowTop) {
            VerticalAnchor.BelowTop belowTop = (VerticalAnchor.BelowTop)anchor;
            int offset = -belowTop.offset();
            if (offset == 0) {
                return Component.translatable((String)"emi_ores.distribution.anchor.top");
            }
            if (offset > 0) {
                return Component.translatable((String)"emi_ores.distribution.anchor.above_top", (Object[])new Object[]{offset});
            }
            return Component.translatable((String)"emi_ores.distribution.anchor.below_top", (Object[])new Object[]{-offset});
        }
        throw new RuntimeException();
    }

    protected static List<Biome> getBiomes(ResourceLocation id, PlacedFeature feature) {
        Registry biomeRegistry = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME);
        return FeaturesReciever.getBiomes().get((Object)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)id)).stream().map(arg_0 -> ((Registry)biomeRegistry).get(arg_0)).toList();
    }

    /*
     * Unable to fully structure code
     */
    protected static void addDistributionGraph(WidgetHolder widgets, int x, int y, HeightProvider heightProvider) {
        block8: {
            block9: {
                block11: {
                    block12: {
                        block10: {
                            block7: {
                                if (heightProvider == null) {
                                    return;
                                }
                                if (!(heightProvider instanceof UniformHeight)) break block7;
                                uniform = (UniformHeight)heightProvider;
                                type = HeightProviderType.UNIFORM;
                                accessor = (UniformHeightAccessor)uniform;
                                min = accessor.getMinInclusive();
                                max = accessor.getMaxInclusive();
                                midHigh = null;
                                midLow = null;
                                break block8;
                            }
                            if (!(heightProvider instanceof TrapezoidHeight)) break block9;
                            trapezoid = (TrapezoidHeight)heightProvider;
                            accessor = (TrapezoidHeightAccessor)trapezoid;
                            min = accessor.getMinInclusive();
                            max = accessor.getMaxInclusive();
                            plateau = accessor.getPlateau();
                            if (!(min instanceof VerticalAnchor.Absolute)) break block10;
                            minAbs = (VerticalAnchor.Absolute)min;
                            if (!(max instanceof VerticalAnchor.Absolute)) break block10;
                            maxAbs = (VerticalAnchor.Absolute)max;
                            midLow = VerticalAnchor.absolute((int)((minAbs.y() + maxAbs.y() - plateau) / 2));
                            midHigh = VerticalAnchor.absolute((int)((minAbs.y() + maxAbs.y() + plateau) / 2));
                            break block11;
                        }
                        if (!(min instanceof VerticalAnchor.AboveBottom)) break block12;
                        minBot = (VerticalAnchor.AboveBottom)min;
                        if (!(max instanceof VerticalAnchor.AboveBottom)) break block12;
                        maxBot = (VerticalAnchor.AboveBottom)max;
                        midLow = VerticalAnchor.aboveBottom((int)((minBot.offset() + maxBot.offset() - plateau) / 2));
                        midHigh = VerticalAnchor.aboveBottom((int)((minBot.offset() + maxBot.offset() + plateau) / 2));
                        break block11;
                    }
                    if (!(min instanceof VerticalAnchor.BelowTop)) ** GOTO lbl-1000
                    minTop = (VerticalAnchor.BelowTop)min;
                    if (max instanceof VerticalAnchor.BelowTop) {
                        maxTop = (VerticalAnchor.BelowTop)max;
                        midLow = VerticalAnchor.belowTop((int)((minTop.offset() + maxTop.offset() - plateau) / 2));
                        midHigh = VerticalAnchor.belowTop((int)((minTop.offset() + maxTop.offset() + plateau) / 2));
                    } else lbl-1000:
                    // 2 sources

                    {
                        midHigh = null;
                        midLow = null;
                    }
                }
                if (plateau == 0) {
                    type = HeightProviderType.TRIANGULAR;
                    if (midLow != null) {
                        widgets.addText(AbstractPlacedFeatureEmiRecipe.anchorText(midLow), 80, 8, 0, false).verticalAlign(TextWidget.Alignment.CENTER).horizontalAlign(TextWidget.Alignment.CENTER);
                    }
                } else {
                    type = HeightProviderType.TRAPEZOID;
                }
                break block8;
            }
            type = null;
            midHigh = null;
            midLow = null;
            max = null;
            min = null;
        }
        if (type != null && min != null && max != null) {
            widgets.addTexture(AbstractPlacedFeatureEmiRecipe.DISTRIBUTION, x, y, 32, 16, 0, type.v).tooltipText(AbstractPlacedFeatureEmiRecipe.getDistributionGraphTooltip(type, min, max, midLow, midHigh));
            widgets.addText(AbstractPlacedFeatureEmiRecipe.anchorText(min), x, y + 8, 0, false).verticalAlign(TextWidget.Alignment.CENTER).horizontalAlign(TextWidget.Alignment.END);
            widgets.addText(AbstractPlacedFeatureEmiRecipe.anchorText(max), x + 32, y + 8, 0, false).verticalAlign(TextWidget.Alignment.CENTER).horizontalAlign(TextWidget.Alignment.START);
        }
    }

    protected static List<Component> getDistributionGraphTooltip(HeightProviderType type, VerticalAnchor min, VerticalAnchor max, VerticalAnchor midLow, VerticalAnchor midHigh) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(type.name);
        tooltip.add((Component)Component.translatable((String)"emi_ores.distribution.range", (Object[])new Object[]{AbstractPlacedFeatureEmiRecipe.anchorTextLong(min), AbstractPlacedFeatureEmiRecipe.anchorTextLong(max)}).withStyle(ChatFormatting.GRAY));
        if (midLow != null && midHigh != null) {
            if (midLow.equals((Object)midHigh)) {
                tooltip.add((Component)Component.translatable((String)"emi_ores.distribution.middle", (Object[])new Object[]{AbstractPlacedFeatureEmiRecipe.anchorTextLong(midLow)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"emi_ores.distribution.middle_range", (Object[])new Object[]{AbstractPlacedFeatureEmiRecipe.anchorTextLong(midLow), AbstractPlacedFeatureEmiRecipe.anchorTextLong(midHigh)}).withStyle(ChatFormatting.GRAY));
            }
        }
        return tooltip;
    }

    protected static Component getVeinFreqComponent(int countMin, int countMax, int rarityChance) {
        MutableComponent veinFreq = countMin != -1 && countMax != -1 ? (countMin == countMax ? Component.translatable((String)"emi_ores.veins_per_chunk", (Object[])new Object[]{countMin}) : Component.translatable((String)"emi_ores.veins_per_chunk_range", (Object[])new Object[]{countMin, countMax})) : (rarityChance != -1 ? Component.translatable((String)"emi_ores.rarity_chance", (Object[])new Object[]{rarityChance}) : null);
        return veinFreq;
    }

    protected static enum HeightProviderType {
        UNIFORM(0, (Component)Component.translatable((String)"emi_ores.distribution.uniform").withStyle(ChatFormatting.BLUE)),
        TRIANGULAR(16, (Component)Component.translatable((String)"emi_ores.distribution.triangle").withStyle(ChatFormatting.GREEN)),
        TRAPEZOID(32, (Component)Component.translatable((String)"emi_ores.distribution.trapezoid").withStyle(ChatFormatting.RED));

        public final int v;
        public final Component name;

        private HeightProviderType(int v, Component name) {
            this.v = v;
            this.name = name;
        }
    }
}

