/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi;

import cc.abbie.emi_ores.client.FeaturesReciever;
import cc.abbie.emi_ores.client.config.EmiOresClientConfig;
import cc.abbie.emi_ores.compat.emi.EmiOresRecipeCategories;
import cc.abbie.emi_ores.compat.emi.recipe.GeodeGenEmiRecipe;
import cc.abbie.emi_ores.compat.emi.recipe.OreGenEmiRecipe;
import cc.abbie.emi_ores.compat.emi.stack.BiomeEmiStack;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

@EmiEntrypoint
public class EmiOresEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        EmiOresClientConfig.load();
        Minecraft client = Minecraft.getInstance();
        if (EmiOresClientConfig.INSTANCE.addBiomesToIndex()) {
            client.level.registryAccess().registryOrThrow(Registries.BIOME).stream().map(BiomeEmiStack::of).forEach(arg_0 -> ((EmiRegistry)registry).addEmiStack(arg_0));
        }
        registry.addCategory(EmiOresRecipeCategories.OREGEN);
        registry.addCategory(EmiOresRecipeCategories.GEODE);
        registry.addDeferredRecipes(consumer -> {
            Map<ResourceLocation, PlacedFeature> features = FeaturesReciever.getFeatures();
            if (features.isEmpty()) {
                return;
            }
            features.forEach((id, placedFeature) -> {
                FeatureConfiguration fc = ((ConfiguredFeature)placedFeature.feature().value()).config();
                if (fc instanceof OreConfiguration) {
                    consumer.accept(new OreGenEmiRecipe((PlacedFeature)placedFeature, (ResourceLocation)id));
                } else if (fc instanceof GeodeConfiguration) {
                    consumer.accept(new GeodeGenEmiRecipe((PlacedFeature)placedFeature, (ResourceLocation)id));
                }
            });
        });
    }

    public void initialize(EmiInitRegistry registry) {
        Registry biomeRegistry = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME);
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(Biome.class, (Registry)biomeRegistry, BiomeEmiStack::of));
        registry.addIngredientSerializer(BiomeEmiStack.class, (EmiIngredientSerializer)new BiomeEmiStack.Serializer());
    }
}

