/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.init;

import com.jkvin114.displaydelight.block.DrinkBlock;
import com.jkvin114.displaydelight.block.EmptyPlateBlock;
import com.jkvin114.displaydelight.block.EmptySmallPlateBlock;
import com.jkvin114.displaydelight.block.FoodBlock;
import com.jkvin114.displaydelight.block.WideFoodBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DisplayBlocks {
    public static final DeferredRegister.Blocks REGISTRY = DeferredRegister.createBlocks((String)"displaydelight");
    public static final DeferredBlock<Block> PLATE = REGISTRY.register("food_plate", () -> new EmptyPlateBlock(BlockBehaviour.Properties.of().noTerrainParticles().instabreak().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_BROWN).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> SMALL_PLATE = REGISTRY.register("small_food_plate", () -> new EmptySmallPlateBlock(BlockBehaviour.Properties.of().noTerrainParticles().instabreak().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_BROWN).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> GLOW_BERRY_CUSTARD = DisplayBlocks.createDrinkFoodBlock("glow_berry_custard");
    public static final DeferredBlock<Block> FRUIT_SALAD = DisplayBlocks.createFoodBlock("fruit_salad");
    public static final DeferredBlock<Block> COOKED_RICE = DisplayBlocks.createFoodBlock("cooked_rice");
    public static final DeferredBlock<Block> MIXED_SALAD = DisplayBlocks.createFoodBlock("mixed_salad");
    public static final DeferredBlock<Block> BEEF_STEW = DisplayBlocks.createFoodBlock("beef_stew");
    public static final DeferredBlock<Block> CHICKEN_SOUP = DisplayBlocks.createFoodBlock("chicken_soup");
    public static final DeferredBlock<Block> VEGETABLE_SOUP = DisplayBlocks.createFoodBlock("vegetable_soup");
    public static final DeferredBlock<Block> FISH_STEW = DisplayBlocks.createFoodBlock("fish_stew");
    public static final DeferredBlock<Block> FRIED_RICE = DisplayBlocks.createFoodBlock("fried_rice");
    public static final DeferredBlock<Block> PUMPKIN_SOUP = DisplayBlocks.createFoodBlock("pumpkin_soup");
    public static final DeferredBlock<Block> BAKED_COD_STEW = DisplayBlocks.createFoodBlock("baked_cod_stew");
    public static final DeferredBlock<Block> NOODLE_SOUP = DisplayBlocks.createFoodBlock("noodle_soup");
    public static final DeferredBlock<Block> BONE_BROTH = DisplayBlocks.createFoodBlock("bone_broth");
    public static final DeferredBlock<Block> BACON_AND_EGGS = DisplayBlocks.createWideFoodBlock("bacon_and_eggs");
    public static final DeferredBlock<Block> PASTA_WITH_MEATBALLS = DisplayBlocks.createWideFoodBlock("pasta_with_meatballs");
    public static final DeferredBlock<Block> PASTA_WITH_MUTTON_CHOP = DisplayBlocks.createWideFoodBlock("pasta_with_mutton_chop");
    public static final DeferredBlock<Block> ROASTED_MUTTON_CHOPS = DisplayBlocks.createWideFoodBlock("roasted_mutton_chops");
    public static final DeferredBlock<Block> STEAK_AND_POTATOES = DisplayBlocks.createWideFoodBlock("steak_and_potatoes");
    public static final DeferredBlock<Block> VEGETABLE_NOODLES = DisplayBlocks.createWideFoodBlock("vegetable_noodles");
    public static final DeferredBlock<Block> RATATOUILLE = DisplayBlocks.createWideFoodBlock("ratatouille");
    public static final DeferredBlock<Block> SQUID_INK_PASTA = DisplayBlocks.createWideFoodBlock("squid_ink_pasta");
    public static final DeferredBlock<Block> GRILLED_SALMON = DisplayBlocks.createWideFoodBlock("grilled_salmon");
    public static final DeferredBlock<Block> MUSHROOM_RICE = DisplayBlocks.createWideFoodBlock("mushroom_rice");
    public static final DeferredBlock<Block> ROAST_CHICKEN = DisplayBlocks.createFoodBlock("roast_chicken");
    public static final DeferredBlock<Block> STUFFED_PUMPKIN = DisplayBlocks.createFoodBlock("stuffed_pumpkin");
    public static final DeferredBlock<Block> HONEY_GLAZED_HAM = DisplayBlocks.createFoodBlock("honey_glazed_ham");
    public static final DeferredBlock<Block> SHEPHEREDS_PIE = DisplayBlocks.createFoodBlock("shepherds_pie");
    public static final DeferredBlock<Block> APPLE_CIDER = DisplayBlocks.createDrinkFoodBlock("apple_cider");
    public static final DeferredBlock<Block> MELON_JUICE = DisplayBlocks.createDrinkFoodBlock("melon_juice");
    public static final DeferredBlock<Block> HOT_COCOA = DisplayBlocks.createDrinkFoodBlock("hot_cocoa");
    public static final DeferredBlock<Block> MUSHROOM_STEW = DisplayBlocks.createFoodBlock("mushroom_stew");
    public static final DeferredBlock<Block> RABBIT_STEW = DisplayBlocks.createFoodBlock("rabbit_stew");
    public static final DeferredBlock<Block> BEETROOT_STEW = DisplayBlocks.createFoodBlock("beetroot_soup");
    public static final DeferredBlock<Block> CD_NACHOS_BOWL = DisplayBlocks.createFoodBlock("cd_nachos_bowl");
    public static final DeferredBlock<Block> CD_CREAMY_COR_DRINK = DisplayBlocks.createDrinkFoodBlock("cd_creamy_corn_drink");
    public static final DeferredBlock<Block> CD_CORNBREAD_STUFFING = DisplayBlocks.createFoodBlock("cd_cornbread_stuffing");
    public static final DeferredBlock<Block> CD_CORN_SOUP = DisplayBlocks.createFoodBlock("cd_corn_soup");
    public static final DeferredBlock<Block> CD_CREAMED_CORN = DisplayBlocks.createFoodBlock("cd_creamed_corn");
    public static final DeferredBlock<Block> ED_ASPARAGUS_SOUP = DisplayBlocks.createFoodBlock("ed_asparagus_soup");
    public static final DeferredBlock<Block> ED_ASPARAGUS_SOUP_CREAMY = DisplayBlocks.createFoodBlock("ed_asparagus_soup_creamy");
    public static final DeferredBlock<Block> ED_ASPARAGUS_AND_BACON_CHEESY = DisplayBlocks.createWideFoodBlock("ed_asparagus_and_bacon_cheesy");
    public static final DeferredBlock<Block> ED_PEPERONATA = DisplayBlocks.createWideFoodBlock("ed_peperonata");
    public static final DeferredBlock<Block> ED_PEANUT_HONEY_SOUP = DisplayBlocks.createFoodBlock("ed_peanut_honey_soup");
    public static final DeferredBlock<Block> ED_MAC_AND_CHEESE = DisplayBlocks.createFoodBlock("ed_mac_and_cheese");
    public static final DeferredBlock<Block> ED_PEANUT_SALAD = DisplayBlocks.createFoodBlock("ed_peanut_salad");
    public static final DeferredBlock<Block> ED_SWEET_POTTATO_SALAD = DisplayBlocks.createFoodBlock("ed_sweet_potato_salad");
    public static final DeferredBlock<Block> ED_CINNAMON_RICE = DisplayBlocks.createFoodBlock("ed_cinnamon_rice");
    public static final DeferredBlock<Block> ED_CINNAMON_APPLES = DisplayBlocks.createFoodBlock("ed_cinnamon_apples");
    public static final DeferredBlock<Block> ED_APPLE_JUICE = DisplayBlocks.createDrinkFoodBlock("ed_apple_juice");
    public static final DeferredBlock<Block> ED_SWEET_BERRY_JUICE = DisplayBlocks.createDrinkFoodBlock("ed_sweet_berry_juice");
    public static final DeferredBlock<Block> ED_GLOW_BERRY_JUICE = DisplayBlocks.createDrinkFoodBlock("ed_glow_berry_juice");
    public static final DeferredBlock<Block> DF_MATCHA_ICE_CREAM = DisplayBlocks.createFoodBlock("df_matcha_ice_cream");
    public static final DeferredBlock<Block> DF_MATCHA_MILKSHAKE = DisplayBlocks.createDrinkFoodBlock("df_matcha_milkshake");
    public static final DeferredBlock<Block> DF_SALMONBERRY_ICE_CREAM = DisplayBlocks.createFoodBlock("df_salmonberry_ice_cream");
    public static final DeferredBlock<Block> DF_SALMONBERRY_MILKSHAKE = DisplayBlocks.createDrinkFoodBlock("df_salmonberry_milkshake");
    public static final DeferredBlock<Block> DF_MATCHA_LATTE = DisplayBlocks.createDrinkFoodBlock("df_matcha_latte");
    public static final DeferredBlock<Block> DF_ENDER_NECTAR = DisplayBlocks.createDrinkFoodBlock("df_ender_nectar");
    public static final DeferredBlock<Block> DF_BERRY_MATCHA_LATTE = DisplayBlocks.createDrinkFoodBlock("df_berry_matcha_latte");
    public static final DeferredBlock<Block> DF_CACTUS_CHILI = DisplayBlocks.createFoodBlock("df_cactus_chili");
    public static final DeferredBlock<Block> DF_FIELD_SALAD = DisplayBlocks.createFoodBlock("df_field_salad");
    public static final DeferredBlock<Block> DF_STUFFED_CANTALOUPE = DisplayBlocks.createFoodBlock("df_stuffed_cantaloupe");
    public static final DeferredBlock<Block> DF_SINIGANG = DisplayBlocks.createFoodBlock("df_sinigang");
    public static final DeferredBlock<Block> DF_CACTUS_SOUP = DisplayBlocks.createFoodBlock("df_cactus_soup");
    public static final DeferredBlock<Block> PD_PINEAPPLE_FRIED_RICE = DisplayBlocks.createFoodBlock("pd_pineapple_fried_rice");
    public static final DeferredBlock<Block> PD_PINEAPPLE_ICE_CREAM = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_ice_cream");
    public static final DeferredBlock<Block> PD_PINEAPPLE_MILK_SHAKE = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_milk_shake");
    public static final DeferredBlock<Block> PD_PINEAPPLE_JUICE = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_juice");
    public static final DeferredBlock<Block> OD_BOWL_OF_GUARDIAN_SOUP = DisplayBlocks.createFoodBlock("od_bowl_of_guardian_soup");
    public static final DeferredBlock<Block> OD_BRAISED_SEA_PICKLE = DisplayBlocks.createFoodBlock("od_braised_sea_pickle");
    public static final DeferredBlock<Block> OD_SEAGRASS_SALAD = DisplayBlocks.createFoodBlock("od_seagrass_salad");
    public static final DeferredBlock<Block> OD_SQUID_RINGS = DisplayBlocks.createFoodBlock("od_squid_rings");
    public static final DeferredBlock<Block> AD_MAGGOT_SALAD = DisplayBlocks.createFoodBlock("ad_maggot_salad");
    public static final DeferredBlock<Block> AD_KANGAROO_STEW = DisplayBlocks.createFoodBlock("ad_kangaroo_stew");
    public static final DeferredBlock<Block> AD_ACACIA_BLOSSOM_SOUP = DisplayBlocks.createFoodBlock("ad_acacia_blossom_soup");
    public static final DeferredBlock<Block> AD_LOBSTER_PASTA = DisplayBlocks.createWideFoodBlock("ad_lobster_pasta");
    public static final DeferredBlock<Block> AD_KANGAROO_PASTA = DisplayBlocks.createWideFoodBlock("ad_kangaroo_pasta");
    public static final DeferredBlock<Block> CTD_HEARTY_SALAD = DisplayBlocks.createFoodBlock("ctd_hearty_salad");
    public static final DeferredBlock<Block> CTD_CREAMED_CORN = DisplayBlocks.createFoodBlock("ctd_creamed_corn");
    public static final DeferredBlock<Block> CTD_SPICY_CURRY = DisplayBlocks.createFoodBlock("ctd_spicy_curry");
    public static final DeferredBlock<Block> CTD_FRIED_EGGPLANT_PASTA = DisplayBlocks.createWideFoodBlock("ctd_fried_eggplant_pasta");
    public static final DeferredBlock<Block> LM_PUFFERFISH_BROTH = DisplayBlocks.createFoodBlock("lm_pufferfish_broth");
    public static final DeferredBlock<Block> LM_POTATO_SOUP = DisplayBlocks.createFoodBlock("lm_potato_soup");
    public static final DeferredBlock<Block> LM_RED_SOUP = DisplayBlocks.createFoodBlock("lm_red_soup");
    public static final DeferredBlock<Block> LM_TOMATO_EGG_SOUP = DisplayBlocks.createFoodBlock("lm_tomato_egg_soup");
    public static final DeferredBlock<Block> LM_COD_DELUXE = DisplayBlocks.createWideFoodBlock("lm_cod_deluxe");
    public static final DeferredBlock<Block> LM_HEARTY_LUNCH = DisplayBlocks.createWideFoodBlock("lm_hearty_lunch");
    public static final DeferredBlock<Block> LM_CHICKEN_CURRY = DisplayBlocks.createWideFoodBlock("lm_chicken_curry");
    public static final DeferredBlock<Block> LM_PASTA_WITH_MUSHROOM_SAUCE = DisplayBlocks.createWideFoodBlock("lm_pasta_with_mushroom_sauce");
    public static final DeferredBlock<Block> LM_OMURICE = DisplayBlocks.createFoodBlock("lm_omurice");
    public static final DeferredBlock<Block> LM_MUSHROOM_POT_PIE = DisplayBlocks.createFoodBlock("lm_mushroom_pot_pie");
    public static final DeferredBlock<Block> LM_ROASTED_MUTTOH_RACK = DisplayBlocks.createFoodBlock("lm_roasted_mutton_rack");
    public static final DeferredBlock<Block> LM_SWEET_BERRY_CUSTARD = DisplayBlocks.createDrinkFoodBlock("lm_sweet_berry_custard");
    public static final DeferredBlock<Block> LM_RICE_PUDDING = DisplayBlocks.createFoodBlock("lm_rice_pudding");
    public static final DeferredBlock<Block> FD_FESTIVE_CHICKEN = DisplayBlocks.createFoodBlock("fd_festive_chicken");
    public static final DeferredBlock<Block> FD_CHRISTMAS_TEA = DisplayBlocks.createDrinkFoodBlock("fd_christmas_tea");
    public static final DeferredBlock<Block> FD_SALMON_VERRINES = DisplayBlocks.createDrinkFoodBlock("fd_salmon_verrines");

    public static Block[] getAll() {
        return new Block[]{(Block)FRUIT_SALAD.get(), (Block)GLOW_BERRY_CUSTARD.get(), (Block)COOKED_RICE.get(), (Block)MIXED_SALAD.get(), (Block)BEEF_STEW.get(), (Block)CHICKEN_SOUP.get(), (Block)VEGETABLE_SOUP.get(), (Block)FISH_STEW.get(), (Block)FRIED_RICE.get(), (Block)PUMPKIN_SOUP.get(), (Block)BAKED_COD_STEW.get(), (Block)NOODLE_SOUP.get(), (Block)BONE_BROTH.get(), (Block)BACON_AND_EGGS.get(), (Block)PASTA_WITH_MEATBALLS.get(), (Block)PASTA_WITH_MUTTON_CHOP.get(), (Block)ROASTED_MUTTON_CHOPS.get(), (Block)STEAK_AND_POTATOES.get(), (Block)VEGETABLE_NOODLES.get(), (Block)RATATOUILLE.get(), (Block)SQUID_INK_PASTA.get(), (Block)GRILLED_SALMON.get(), (Block)MUSHROOM_RICE.get(), (Block)ROAST_CHICKEN.get(), (Block)STUFFED_PUMPKIN.get(), (Block)HONEY_GLAZED_HAM.get(), (Block)SHEPHEREDS_PIE.get(), (Block)APPLE_CIDER.get(), (Block)MELON_JUICE.get(), (Block)HOT_COCOA.get(), (Block)MUSHROOM_STEW.get(), (Block)RABBIT_STEW.get(), (Block)BEETROOT_STEW.get(), (Block)CD_NACHOS_BOWL.get(), (Block)CD_CREAMY_COR_DRINK.get(), (Block)CD_CORN_SOUP.get(), (Block)CD_CORNBREAD_STUFFING.get(), (Block)CD_CREAMED_CORN.get(), (Block)ED_ASPARAGUS_SOUP.get(), (Block)ED_ASPARAGUS_SOUP_CREAMY.get(), (Block)ED_ASPARAGUS_AND_BACON_CHEESY.get(), (Block)ED_PEPERONATA.get(), (Block)ED_PEANUT_HONEY_SOUP.get(), (Block)ED_MAC_AND_CHEESE.get(), (Block)ED_PEANUT_SALAD.get(), (Block)ED_SWEET_POTTATO_SALAD.get(), (Block)ED_CINNAMON_RICE.get(), (Block)ED_CINNAMON_APPLES.get(), (Block)ED_APPLE_JUICE.get(), (Block)ED_SWEET_BERRY_JUICE.get(), (Block)ED_GLOW_BERRY_JUICE.get(), (Block)DF_MATCHA_ICE_CREAM.get(), (Block)DF_MATCHA_LATTE.get(), (Block)DF_MATCHA_MILKSHAKE.get(), (Block)DF_SALMONBERRY_ICE_CREAM.get(), (Block)DF_SALMONBERRY_MILKSHAKE.get(), (Block)DF_ENDER_NECTAR.get(), (Block)DF_BERRY_MATCHA_LATTE.get(), (Block)DF_CACTUS_CHILI.get(), (Block)DF_FIELD_SALAD.get(), (Block)DF_STUFFED_CANTALOUPE.get(), (Block)DF_SINIGANG.get(), (Block)DF_CACTUS_SOUP.get(), (Block)PD_PINEAPPLE_FRIED_RICE.get(), (Block)PD_PINEAPPLE_JUICE.get(), (Block)PD_PINEAPPLE_ICE_CREAM.get(), (Block)PD_PINEAPPLE_MILK_SHAKE.get(), (Block)OD_SQUID_RINGS.get(), (Block)OD_BRAISED_SEA_PICKLE.get(), (Block)OD_SEAGRASS_SALAD.get(), (Block)OD_BOWL_OF_GUARDIAN_SOUP.get(), (Block)AD_ACACIA_BLOSSOM_SOUP.get(), (Block)AD_KANGAROO_PASTA.get(), (Block)AD_KANGAROO_STEW.get(), (Block)AD_MAGGOT_SALAD.get(), (Block)AD_LOBSTER_PASTA.get(), (Block)CTD_HEARTY_SALAD.get(), (Block)CTD_CREAMED_CORN.get(), (Block)CTD_SPICY_CURRY.get(), (Block)CTD_FRIED_EGGPLANT_PASTA.get(), (Block)LM_PUFFERFISH_BROTH.get(), (Block)LM_POTATO_SOUP.get(), (Block)LM_RED_SOUP.get(), (Block)LM_TOMATO_EGG_SOUP.get(), (Block)LM_COD_DELUXE.get(), (Block)LM_HEARTY_LUNCH.get(), (Block)LM_CHICKEN_CURRY.get(), (Block)LM_PASTA_WITH_MUSHROOM_SAUCE.get(), (Block)LM_OMURICE.get(), (Block)LM_MUSHROOM_POT_PIE.get(), (Block)LM_ROASTED_MUTTOH_RACK.get(), (Block)LM_SWEET_BERRY_CUSTARD.get(), (Block)LM_RICE_PUDDING.get(), (Block)FD_CHRISTMAS_TEA.get(), (Block)FD_FESTIVE_CHICKEN.get(), (Block)FD_SALMON_VERRINES.get()};
    }

    private static BlockBehaviour.Properties baseProps() {
        return BlockBehaviour.Properties.of().noOcclusion().noTerrainParticles().instabreak().pushReaction(PushReaction.DESTROY).mapColor(MapColor.NONE);
    }

    private static DeferredBlock<Block> createDrinkFoodBlock(String name) {
        return REGISTRY.register(name, () -> new DrinkBlock(DisplayBlocks.baseProps().sound(SoundType.GLASS)));
    }

    private static DeferredBlock<Block> createWideFoodBlock(String name) {
        return REGISTRY.register(name, () -> new WideFoodBlock(DisplayBlocks.baseProps().sound(SoundType.WOOD)));
    }

    private static DeferredBlock<Block> createFoodBlock(String name) {
        return REGISTRY.register(name, () -> new FoodBlock(DisplayBlocks.baseProps().sound(SoundType.WOOD)));
    }
}

