/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.events;

import com.jkvin114.displaydelight.events.InterationManager;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayTags;
import com.jkvin114.displaydelight.init.PlatedBlocks;
import com.jkvin114.displaydelight.init.SmallPlatedBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="displaydelight")
public class DisplayEvents {
    @SubscribeEvent
    public static void onCheck(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean placed = false;
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().isEmpty()) {
            placed = InterationManager.tryTakeItemWithBareHand(event.getEntity(), level2, event.getHitVec());
        }
        if (!placed && event.getItemStack().is(DisplayTags.SMALL_PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnSmallPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().is(DisplayTags.PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().is(DisplayTags.DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItem(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (placed) {
            event.setCanceled(true);
        }
    }

    private static boolean isVanilaFood(ItemStack item) {
        return item.is(Items.MUSHROOM_STEW) || item.is(Items.RABBIT_STEW) || item.is(Items.BEETROOT_SOUP);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            List drops;
            Block[] array;
            ServerLevel lvl = (ServerLevel)levelAccessor;
            for (Block target : array = DisplayBlocks.getAll()) {
                drops = Block.getDrops((BlockState)target.defaultBlockState(), (ServerLevel)lvl, (BlockPos)BlockPos.containing((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.getFirst()).is(DisplayTags.DISPLAYABLE) || ((Boolean)DisplayConfig.DISABLE_VANILLA_FOODS.get()).booleanValue() && DisplayEvents.isVanilaFood((ItemStack)drops.getFirst())) continue;
                BlockAssociations.addToMap(((ItemStack)drops.getFirst()).getItem(), target, false);
            }
            for (Block target : PlatedBlocks.getAll()) {
                drops = Block.getDrops((BlockState)target.defaultBlockState(), (ServerLevel)lvl, (BlockPos)BlockPos.containing((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.getFirst()).is(DisplayTags.PLATE_DISPLAYABLE)) continue;
                BlockAssociations.addToMap(((ItemStack)drops.getFirst()).getItem(), target, true);
            }
            for (Block target : SmallPlatedBlocks.getAll()) {
                drops = Block.getDrops((BlockState)target.defaultBlockState(), (ServerLevel)lvl, (BlockPos)BlockPos.containing((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.getFirst()).is(DisplayTags.SMALL_PLATE_DISPLAYABLE)) continue;
                BlockAssociations.addSmallPlateToMap(((ItemStack)drops.getFirst()).getItem(), target);
            }
        }
    }
}

