/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.turret;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.content.tools.ChemicalSprayerProjectileEntity;
import com.jesz.createdieselgenerators.content.turret.TurretBlockEntity;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ChemicalTurretBlockEntity
extends TurretBlockEntity {
    public boolean lighterUpgrade = false;
    public boolean shootNextTick = false;
    public SmartFluidTankBehaviour tank;
    public AbstractComputerBehaviour computerBehaviour;
    public int redstoneSignal;

    public ChemicalTurretBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float calculateStressApplied() {
        return 4.0f;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.CHEMICAL_TURRET.get(), (be, side) -> {
            if (side == null || side == Direction.DOWN) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.redstoneSignal != 0 || this.shootNextTick) {
            this.shootFluids();
            this.shootNextTick = false;
        }
        if (this.targetedEntity == null) {
            return;
        }
        if (this.controllingEntity == null) {
            this.targetedEntity = null;
            return;
        }
        if ((Math.abs(this.targetedHorizontalRotation - this.horizontalRotation) % 360.0f <= 2.0f || Math.abs(this.targetedHorizontalRotation - this.horizontalRotation) % 360.0f >= 358.0f) && Math.abs(this.targetedVerticalRotation - this.verticalRotation) <= 2.0f) {
            this.shootFluids();
        }
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.lighterUpgrade = compound.getBoolean("LighterUpgrade");
        this.redstoneSignal = compound.getInt("RedstoneSignal");
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("LighterUpgrade", this.lighterUpgrade);
        compound.putInt("RedstoneSignal", this.redstoneSignal);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void shootFluids() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        float shootingForce = this.getShootingForce();
        if (!this.level.isClientSide && !this.tank.isEmpty()) {
            AllSoundEvents.MIXING.playOnServer(this.level, (Vec3i)this.worldPosition, 0.75f, 1.0f);
            FluidStack fluidStack = this.tank.getPrimaryHandler().getFluid().copy();
            boolean flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fluidStack.getFluid()).normal().speed() != 0.0f;
            ChemicalSprayerProjectileEntity projectile = ChemicalSprayerProjectileEntity.spray(this.level, fluidStack, flammable && this.lighterUpgrade || fluidStack.getFluid().isSame((Fluid)Fluids.LAVA), fluidStack.getFluid().isSame((Fluid)Fluids.WATER));
            projectile.setPos(Vec3.atCenterOf((Vec3i)this.worldPosition).add(0.0, 0.625, 0.0));
            Vec3 directionVector = new Vec3(-Math.sin(Math.toRadians(this.horizontalRotation)) * Math.cos(Math.toRadians(-this.verticalRotation)), Math.sin(Math.toRadians(-this.verticalRotation)), -Math.cos(Math.toRadians(this.horizontalRotation)) * Math.cos(Math.toRadians(-this.verticalRotation)));
            projectile.shoot(directionVector.x, directionVector.y, directionVector.z, shootingForce, 5.0f);
            projectile.setOwner((Entity)(this.controllingPlayer != null ? this.controllingPlayer : this.controllingEntity));
            this.level.addFreshEntity((Entity)projectile);
            if (this.t == 1) {
                this.tank.getPrimaryHandler().drain(3, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static class ChemicalTurretValueBox
    extends ValueBoxTransform.Sided {
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)3.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }
}

