/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools.lighter;

import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.tools.FueledToolItem;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterItemRenderer;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class LighterItem
extends Item
implements FueledToolItem {
    public LighterItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        this.createTooltip(tooltipComponents, stack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xEFEFEF;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        FluidStack fStack = this.readFluid(stack);
        boolean flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fStack.getFluid()).normal().speed() != 0.0f;
        Integer state = (Integer)stack.get(CDGDataComponents.LIGHTER_STATE);
        if (!flammable && state != null && state == 2) {
            stack.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        level.playSound(player, player.blockPosition(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        if (!stackInHand.has(CDGDataComponents.LIGHTER_STATE)) {
            stackInHand.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
            return InteractionResultHolder.success((Object)stackInHand);
        }
        if ((Integer)stackInHand.get(CDGDataComponents.LIGHTER_STATE) == 0) {
            if (player.isShiftKeyDown()) {
                stackInHand.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
                return InteractionResultHolder.success((Object)stackInHand);
            }
            FluidStack fStack = this.readFluid(stackInHand);
            boolean flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fStack.getFluid()).normal().speed() != 0.0f;
            stackInHand.set(CDGDataComponents.LIGHTER_STATE, (Object)(flammable ? 2 : 1));
            if (flammable) {
                fStack.setAmount(fStack.getAmount() - 1);
                this.writeFluid(stackInHand, fStack);
            }
            return InteractionResultHolder.success((Object)stackInHand);
        }
        stackInHand.set(CDGDataComponents.LIGHTER_STATE, (Object)0);
        return InteractionResultHolder.success((Object)stackInHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        boolean flammable;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        ItemStack stack = context.getItemInHand();
        if (!stack.has(CDGDataComponents.LIGHTER_STATE) || (Integer)stack.get(CDGDataComponents.LIGHTER_STATE) != 2) {
            return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
        }
        if (!(CampfireBlock.canLight((BlockState)blockstate) || CandleBlock.canLight((BlockState)blockstate) || CandleCakeBlock.canLight((BlockState)blockstate) || blockstate.is(AllTags.optionalTag((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)CreateDieselGenerators.rl("lighter_"))))) {
            BlockPos blockpos1 = blockpos.relative(context.getClickedFace());
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockpos1, (Direction)context.getHorizontalDirection())) {
                boolean flammable2;
                FluidStack fStack;
                level.playSound(player, blockpos1, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState blockstate1 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockpos1);
                level.setBlock(blockpos1, blockstate1, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1, stack);
                }
                if ((fStack = this.readFluid(stack)).getAmount() == 0) {
                    stack.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
                    return InteractionResult.FAIL;
                }
                boolean bl = flammable2 = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fStack.getFluid()).normal().speed() != 0.0f;
                if (flammable2 && (Integer)stack.get(CDGDataComponents.LIGHTER_STATE) == 2) {
                    fStack.setAmount(fStack.getAmount() - 1);
                    this.writeFluid(stack, fStack);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
        }
        level.playSound(player, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        if (blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
            level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockpos);
        FluidStack fStack = this.readFluid(stack);
        if (fStack.getAmount() == 0) {
            stack.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
            return InteractionResult.FAIL;
        }
        boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fStack.getFluid()).normal().speed() != 0.0f;
        if (flammable && (Integer)stack.get(CDGDataComponents.LIGHTER_STATE) == 2) {
            fStack.setAmount(fStack.getAmount() - 1);
            this.writeFluid(stack, fStack);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCurrentFillLevel(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)this.getCurrentFillLevel(stack) / (float)this.getCapacity(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerExtension(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new LighterItemRenderer()), new Item[]{this});
    }
}

