/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.content.tools.ChemicalSprayerProjectileEntity;
import com.jesz.createdieselgenerators.content.tools.FueledToolItem;
import com.jesz.createdieselgenerators.content.tools.wire_cutters.WireCuttersItemRenderer;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemicalSprayerItem
extends Item
implements CustomArmPoseItem,
FueledToolItem {
    boolean lighter;

    public ChemicalSprayerItem(Item.Properties properties, boolean lighter) {
        super(properties.stacksTo(1));
        this.lighter = lighter;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        this.createTooltip(tooltipComponents, stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (player.swinging) {
            return null;
        }
        return HumanoidModel.ArmPose.CROSSBOW_HOLD;
    }

    public int getBarColor(ItemStack stack) {
        return 0xEFEFEF;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (this.getCurrentFillLevel(stackInHand) > 0) {
            player.startUsingItem(hand);
        }
        return super.use(level, player, hand);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(AllEnchantments.CAPACITY)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        FluidStack fluidStack = this.readFluid(stack);
        if (!fluidStack.isEmpty()) {
            if (!level.isClientSide) {
                Player p;
                if (count % 2 == 0) {
                    boolean fire = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fluidStack.getFluid()).normal().speed() != 0.0f;
                    ChemicalSprayerProjectileEntity projectile = ChemicalSprayerProjectileEntity.spray(level, fluidStack, fire && this.lighter || fluidStack.getFluid().isSame((Fluid)Fluids.LAVA), fluidStack.getFluid().isSame((Fluid)Fluids.WATER));
                    projectile.setPos(player.position().add(0.0, 1.5, 0.0));
                    projectile.shootFromRotation((Entity)player, player.getXRot() + new Random().nextFloat(-5.0f, 5.0f), player.getYRot() + new Random().nextFloat(-5.0f, 5.0f), 0.0f, 1.0f, 1.0f);
                    level.addFreshEntity((Entity)projectile);
                    fluidStack.setAmount(fluidStack.getAmount() - 1);
                }
                if (!(player instanceof Player && (p = (Player)player).isCreative() || count % 25 != 0)) {
                    this.writeFluid(stack, fluidStack);
                }
            } else if (count % 2 == 0) {
                AllSoundEvents.MIXING.playAt(level, (Vec3i)player.blockPosition(), 0.75f, 1.0f, true);
            }
        }
        super.onUseTick(level, player, stack, count);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCurrentFillLevel(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * ((float)this.getCurrentFillLevel(stack) / (float)this.getCapacity(stack)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerExtension(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new WireCuttersItemRenderer()), new Item[]{this});
    }
}

