/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterItem;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilteringBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityFilteringRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.getInstance();
        HitResult target = mc.hitResult;
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        BlockState state = level.getBlockState(pos);
        FilteringBehaviour behaviour = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, EntityFilteringBehaviour.TYPE);
        if (mc.player.isShiftKeyDown()) {
            return;
        }
        ItemStack mainhandItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (behaviour == null) {
            return;
        }
        if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(result.getDirection())) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.getSlotPositioning() instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.getSlotPositioning()).fromSide(result.getDirection());
        }
        if (!behaviour.getSlotPositioning().shouldRender((LevelAccessor)level, pos, state)) {
            return;
        }
        ItemStack filter = behaviour.getFilter();
        boolean isFilterSlotted = filter.getItem() instanceof EntityFilterItem;
        MutableComponent label = behaviour.getLabel();
        boolean hit = behaviour.getSlotPositioning().testHit((LevelAccessor)level, pos, state, target.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)));
        AABB emptyBB = new AABB(Vec3.ZERO, Vec3.ZERO);
        AABB bb = isFilterSlotted ? emptyBB.inflate((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.inflate(0.25);
        ValueBox.ItemValueBox box = new ValueBox.ItemValueBox((Component)label, bb, pos, filter, behaviour.getCountLabelForValueBox());
        box.passive(!hit || AllBlocks.CLIPBOARD.isIn(mainhandItem));
        Outliner.getInstance().showOutline((Object)Pair.of((Object)("filter" + behaviour.netId()), (Object)pos), (Outline)box.transform(behaviour.getSlotPositioning())).lineWidth(0.015625f).withFaceTexture((BindableTexture)(hit ? AllSpecialTextures.THIN_CHECKERED : null)).highlightFace(result.getDirection());
        if (!hit) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(label.copy());
        tip.add(CreateLang.translateDirect((String)(filter.isEmpty() ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"), (Object[])new Object[0]));
        CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
    }

    public static void renderOnBlockEntity(SmartBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be == null || be.isRemoved()) {
            return;
        }
        Level level = be.getLevel();
        BlockPos blockPos = be.getBlockPos();
        for (BlockEntityBehaviour b : be.getAllBehaviours()) {
            Entity cameraEntity;
            if (!(b instanceof EntityFilteringBehaviour)) continue;
            EntityFilteringBehaviour behaviour = (EntityFilteringBehaviour)b;
            if (!be.isVirtual() && (cameraEntity = Minecraft.getInstance().cameraEntity) != null && level == cameraEntity.level()) {
                float max = behaviour.getRenderDistance();
                if (cameraEntity.position().distanceToSqr(VecHelper.getCenterOf((Vec3i)blockPos)) > (double)(max * max)) continue;
            }
            if (!behaviour.isActive() || behaviour.getFilter().isEmpty()) continue;
            ValueBoxTransform slotPositioning = behaviour.getSlotPositioning();
            BlockState blockState = be.getBlockState();
            if (slotPositioning instanceof ValueBoxTransform.Sided) {
                ValueBoxTransform.Sided sided = (ValueBoxTransform.Sided)slotPositioning;
                Direction side = sided.getSide();
                for (Direction d : Iterate.directions) {
                    ItemStack filter = behaviour.getFilter(d);
                    if (filter.isEmpty()) continue;
                    sided.fromSide(d);
                    if (!slotPositioning.shouldRender((LevelAccessor)level, blockPos, blockState)) continue;
                    ms.pushPose();
                    slotPositioning.transform((LevelAccessor)level, blockPos, blockState, ms);
                    if (AllBlocks.CONTRAPTION_CONTROLS.has(blockState)) {
                        ValueBoxRenderer.renderFlatItemIntoValueBox((ItemStack)filter, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
                    } else {
                        ValueBoxRenderer.renderItemIntoValueBox((ItemStack)filter, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
                    }
                    ms.popPose();
                }
                sided.fromSide(side);
                continue;
            }
            if (!slotPositioning.shouldRender((LevelAccessor)level, blockPos, blockState)) continue;
            ms.pushPose();
            slotPositioning.transform((LevelAccessor)level, blockPos, blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox((ItemStack)behaviour.getFilter(), (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
            ms.popPose();
        }
    }
}

