/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.modular;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineValueBox;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ModularDieselEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IEngine,
IMultiBlockEntityContainer.Fluid {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    protected float remainingTicks = 0.0f;
    protected int length = 1;
    @NotNull
    protected EngineUpgrades upgrade = EngineUpgrades.EMPTY;
    protected IFluidHandler fluidCapability;
    protected FluidTank tankInventory = new SmartFluidTank(1000, f -> this.sendData());
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    @OnlyIn(value=Dist.CLIENT)
    protected EngineSoundInstance soundInstance;

    public ModularDieselEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ModularDieselEngineValueBox());
        this.movementDirection.withCallback(this::onDirectionChanged);
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        super.addBehaviours(behaviours);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.MODULAR_DIESEL_ENGINE.get(), (be, side) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            if (side == null || side == Direction.UP && ((Boolean)be.getBlockState().getValue((Property)ModularDieselEngineBlock.PIPE)).booleanValue()) {
                return be.fluidCapability;
            }
            return null;
        });
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.isController()) {
            if (this.getGeneratedSpeed() == 0.0f) {
                return false;
            }
            super.addToGoggleTooltip(tooltip, isPlayerSneaking);
            this.containedFluidTooltip(tooltip, isPlayerSneaking, this.fluidCapability);
            return true;
        }
        ModularDieselEngineBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return false;
        }
        return controller.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public void onDirectionChanged(int v) {
        ModularDieselEngineBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.movementDirection.setValue(v);
            controller.reActivateSource = true;
            for (int i = 0; i < controller.getHeight(); ++i) {
                BlockEntity blockEntity = this.level.getBlockEntity(controller.getBlockPos().relative(((Direction)controller.getBlockState().getValue((Property)ModularDieselEngineBlock.FACING)).getAxis(), i));
                if (!(blockEntity instanceof ModularDieselEngineBlockEntity)) continue;
                ModularDieselEngineBlockEntity be = (ModularDieselEngineBlockEntity)blockEntity;
                if (be.movementDirection.getValue() == v) continue;
                be.movementDirection.setValue(v);
            }
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.upgrade.getCapacity(this.getFuelCapacity() * (float)this.getHeight() * (1.0f / this.upgrade.getSpeed(this.getFuelSpeed(), this)) * this.getFuelSpeed(), this);
        return capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.enabled() || !this.isController() || this.remainingTicks < 1.0f) {
            return 0.0f;
        }
        return ModularDieselEngineBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * this.upgrade.getSpeed(this.getFuelSpeed(), this)), (Direction)((Direction)this.getBlockState().getValue((Property)ModularDieselEngineBlock.FACING)));
    }

    public void tick() {
        super.tick();
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (!this.isController()) {
            if (this.upgrade == EngineUpgrades.EMPTY) {
                return;
            }
            ModularDieselEngineBlockEntity controller = this.getControllerBE();
            if (controller.upgrade == EngineUpgrades.EMPTY) {
                controller.upgrade = this.upgrade;
            } else {
                Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.upgrade.getItem());
            }
            this.upgrade = EngineUpgrades.EMPTY;
            return;
        }
        this.reActivateSource = true;
        if (this.enabled()) {
            if (this.remainingTicks < (float)(this.length + 1)) {
                this.remainingTicks += (float)this.length / this.getFuelBurnRate();
                this.tankInventory.drain(this.length, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.remainingTicks >= 0.0f) {
                this.remainingTicks -= (float)this.length;
            }
        }
        if (this.level.isClientSide) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::tickClient);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        if (this.enabled()) {
            Vec3 pos = Vec3.atCenterOf((Vec3i)this.getBlockPos());
            pos = ((Direction)this.getBlockState().getValue((Property)ModularDieselEngineBlock.FACING)).getAxis() == Direction.Axis.X ? pos.add((double)this.length / 2.0 - 0.5, 0.0, 0.0) : pos.add(0.0, 0.0, (double)this.length / 2.0 - 0.5);
            if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getX() != pos.x || this.soundInstance.getZ() != pos.z) {
                this.soundInstance = this.upgrade.createSoundInstance(this, pos);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            } else if (this.soundInstance.active()) {
                this.soundInstance.keepAlive();
                this.soundInstance.setPitch(this.upgrade.getPitchMultiplier(this) * this.getFuelSoundPitch());
                this.soundInstance.setVolume(this.upgrade.getVolume(this));
            }
        } else if (this.soundInstance != null) {
            this.soundInstance.fadeOut();
            this.soundInstance = null;
        }
    }

    void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    @Override
    public float getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public FluidTank getTank() {
        return this.tankInventory;
    }

    @Override
    public EngineUpgrades getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(EngineUpgrades upgrade) {
        this.upgrade = upgrade;
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    public ModularDieselEngineBlockEntity getControllerBE() {
        if (this.isController() || !this.hasLevel()) {
            return this;
        }
        BlockEntity be = this.level.getBlockEntity(this.controller);
        if (be instanceof ModularDieselEngineBlockEntity) {
            return (ModularDieselEngineBlockEntity)be;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.controller.equals((Object)this.worldPosition);
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.length = 1;
        this.reActivateSource = true;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevHeight = this.length;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.upgrade = EngineUpgrades.get(ResourceLocation.parse((String)compound.getString("Upgrade")));
        this.remainingTicks = compound.getFloat("remainingTicks");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        if (this.isController()) {
            this.length = compound.getInt("Height");
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevHeight != this.length) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(1000);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putString("Upgrade", this.upgrade.getId().toString());
            compound.putFloat("remainingTicks", this.remainingTicks);
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            compound.putInt("Height", this.length);
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.reActivateSource = true;
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return ((Direction)this.getBlockState().getValue((Property)ModularDieselEngineBlock.FACING)).getAxis();
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return 21;
    }

    public int getMaxWidth() {
        return 1;
    }

    public int getHeight() {
        return this.length;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public int getWidth() {
        return 1;
    }

    public void setWidth(int width) {
    }

    @Override
    public boolean enabled() {
        if (!IEngine.super.enabled()) {
            return false;
        }
        if (!((Boolean)CDGConfig.ENGINES_DISABLED_WITH_REDSTONE.get()).booleanValue()) {
            return true;
        }
        for (int i = 1; i < this.length; ++i) {
            BlockState state = this.level.getBlockState(this.getBlockPos().relative(this.getMainConnectionAxis(), i));
            if (!CDGBlocks.MODULAR_DIESEL_ENGINE.has(state) || !((Boolean)state.getValue((Property)DieselEngineBlock.POWERED)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

