/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PoweredEngineShaftBlockEntity
extends GeneratingKineticBlockEntity {
    float stressCapacity;
    float speed;
    int movementDirection = 0;
    int initialTicks;
    public List<Pair<BlockPos, Couple<Float>>> engines = new ArrayList<Pair<BlockPos, Couple<Float>>>(4);

    public PoweredEngineShaftBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean isEngineForConnectorDisplay(BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS);
        for (Direction d : List.of(axis == Direction.Axis.Z ? Direction.UP : Direction.NORTH, axis == Direction.Axis.Z ? Direction.DOWN : Direction.SOUTH, axis == Direction.Axis.X ? Direction.UP : Direction.EAST, axis == Direction.Axis.X ? Direction.DOWN : Direction.WEST)) {
            BlockState st = this.getLevel().getBlockState(this.getBlockPos().relative(d, 2));
            if (!(st.getBlock() instanceof HugeDieselEngineBlock) || st.getValue((Property)HugeDieselEngineBlock.FACING) != d.getOpposite()) continue;
            return this.getBlockPos().relative(d, 2).equals((Object)pos);
        }
        return false;
    }

    public void update(BlockPos sourcePos, int direction, float stress, float speed) {
        Pair<BlockPos, Couple<Float>> found = null;
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            if (!((BlockPos)engine.getFirst()).equals((Object)sourcePos)) continue;
            found = engine;
            break;
        }
        ArrayList<Pair<BlockPos, Couple<Float>>> newEngines = new ArrayList<Pair<BlockPos, Couple<Float>>>(this.engines);
        if (found != null) {
            newEngines.remove(found);
        }
        newEngines.add((Pair<BlockPos, Couple<Float>>)Pair.of((Object)sourcePos, (Object)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed))));
        this.engines = newEngines;
        AtomicReference<Float> maxSpeed = new AtomicReference<Float>(Float.valueOf(0.0f));
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            if (!(((Float)((Couple)engine.getSecond()).getSecond()).floatValue() > maxSpeed.get().floatValue())) continue;
            maxSpeed.set((Float)((Couple)engine.getSecond()).getSecond());
        }
        this.speed = maxSpeed.get().floatValue();
        this.movementDirection = direction;
        this.reActivateSource = true;
    }

    public boolean canBePoweredBy() {
        return this.initialTicks == 0;
    }

    public void removeGenerator(BlockPos sourcePos) {
        ArrayList<Pair<BlockPos, Couple<Float>>> newEngines = new ArrayList<Pair<BlockPos, Couple<Float>>>(this.engines);
        newEngines.removeIf(p -> ((BlockPos)p.getFirst()).equals((Object)sourcePos));
        this.engines = newEngines;
        if (this.engines.isEmpty()) {
            this.movementDirection = 0;
            this.speed = 0.0f;
            this.stressCapacity = 0.0f;
        }
        this.reActivateSource = true;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.putInt("Warmup", this.initialTicks);
        }
        ListTag engineList = new ListTag();
        for (Pair<BlockPos, Couple<Float>> engine : List.copyOf(this.engines)) {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("Capacity", ((Float)((Couple)engine.getSecond()).getFirst()).floatValue());
            tag.putFloat("Speed", ((Float)((Couple)engine.getSecond()).getSecond()).floatValue());
            tag.put("Pos", NbtUtils.writeBlockPos((BlockPos)((BlockPos)engine.getFirst())));
            engineList.add((Object)tag);
        }
        compound.putFloat("GeneratedSpeed", this.speed);
        compound.put("Engines", (Tag)engineList);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.movementDirection = compound.getInt("Direction");
        this.initialTicks = compound.getInt("Warmup");
        ListTag engineList = compound.getList("Engines", 10);
        ArrayList<Pair<BlockPos, Couple<Float>>> newEngines = new ArrayList<Pair<BlockPos, Couple<Float>>>();
        for (int i = 0; i < engineList.size(); ++i) {
            newEngines.add((Pair<BlockPos, Couple<Float>>)Pair.of((Object)NBTHelper.readBlockPos((CompoundTag)engineList.getCompound(i), (String)"Pos"), (Object)Couple.create((Object)Float.valueOf(engineList.getCompound(i).getFloat("Capacity")), (Object)Float.valueOf(engineList.getCompound(i).getFloat("Speed")))));
        }
        this.engines = newEngines;
        this.speed = compound.getFloat("GeneratedSpeed");
    }

    public float getGeneratedSpeed() {
        return (float)this.movementDirection * this.speed;
    }

    public float calculateAddedStressCapacity() {
        if (this.movementDirection == 0) {
            return 0.0f;
        }
        float capacity = 0.0f;
        for (Pair<BlockPos, Couple<Float>> engine : this.engines) {
            capacity += ((Float)((Couple)engine.getSecond()).getFirst()).floatValue();
        }
        this.lastCapacityProvided = capacity;
        return capacity;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCoords = axis.choose(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }
}

