/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.burner;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.content.burner.BurnerBlock;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BurnerBlockEntity
extends KineticBlockEntity {
    public float heat = -1.0f;
    SmartFluidTank tank = new SmartFluidTank(100, f -> {});
    public float valveState = 0.2f;
    public float prevValveState;
    int tick;
    float multiplier;
    boolean ignited = false;
    int ignitionTries;
    int x = 0;
    int y = 0;

    public void tick() {
        boolean containsValidFuel;
        this.tick = (this.tick + 1) % 40000;
        super.tick();
        this.prevValveState = this.valveState;
        this.valveState = Mth.clamp((float)(this.valveState + this.getSpeed() / 5000.0f), (float)0.0f, (float)1.0f);
        boolean bl = containsValidFuel = !this.tank.getFluid().isEmpty();
        if (containsValidFuel) {
            this.multiplier = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), this.tank.getFluid().getFluid()).burnerStrength();
        }
        if (this.multiplier == 0.0f) {
            containsValidFuel = false;
        }
        if (this.valveState == 0.0f || !containsValidFuel) {
            this.heat = -1.0f;
            if (!this.level.isClientSide) {
                if (this.ignited) {
                    this.level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.3f, this.level.getRandom().nextFloat() * 0.4f + 0.7f);
                }
                this.ignited = false;
                this.ignitionTries = 0;
            }
        }
        if (containsValidFuel && this.valveState != 0.0f) {
            this.heat = (this.valveState + 1.0f) * this.multiplier;
            if (this.level.isClientSide) {
                return;
            }
            if (this.tick % 5 == 0 && !this.ignited) {
                this.level.playSound(null, this.worldPosition, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.5f, this.level.getRandom().nextFloat() * 0.4f + 0.7f);
                ++this.ignitionTries;
                if (this.ignitionTries > 4) {
                    this.ignited = true;
                }
            }
            if ((int)((float)this.tick % (10.0f / this.valveState)) == 0) {
                this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.sendData();
                this.setChanged();
            }
        }
        if (this.level.isClientSide) {
            return;
        }
        if (this.getBlockState().getValue(BurnerBlock.HEAT_LEVEL) != this.calculateHeatLevel(this.heat)) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)this.getBlockState().setValue(BurnerBlock.HEAT_LEVEL, (Comparable)this.calculateHeatLevel(this.heat))).setValue((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(this.heat > 0.0f)));
            this.notifyUpdate();
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (this.valveState == 0.0f || this.heat == -1.0f) {
            return;
        }
        RandomSource random = RandomSource.create();
        if (this.tick % 100 == 0) {
            this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.0f, true);
        }
        this.x = (this.x + 1) % 4;
        if (this.x == 3) {
            this.y = (this.y + 1) % 4;
        }
        if (this.x != 0 && this.x != 3 && this.y != 0 && this.y != 3) {
            return;
        }
        if (this.heat >= 1.8f && random.nextInt(0, (int)(1.0f + this.heat * 2.0f)) != 1) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)this.worldPosition.getX() + 0.3475 + (double)this.x / 9.0, (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.3475 + (double)this.y / 9.0, 0.0, 0.02 * (double)this.valveState, 0.0);
            return;
        }
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)this.worldPosition.getX() + 0.3475 + (double)((float)this.x / 9.0f), (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.3475 + (double)((float)this.y / 9.0f), 0.0, 0.02 * (double)this.valveState, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.3475 + (double)((float)this.x / 9.0f), (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.3475 + (double)((float)this.y / 9.0f), 0.0, 0.02 * (double)this.valveState, 0.0);
    }

    public BlazeBurnerBlock.HeatLevel calculateHeatLevel(float heat) {
        if ((double)heat >= 1.8) {
            return BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if ((double)heat >= 1.4) {
            return BlazeBurnerBlock.HeatLevel.KINDLED;
        }
        if ((double)heat >= 1.2) {
            return BlazeBurnerBlock.HeatLevel.FADING;
        }
        if (heat >= 1.0f) {
            return BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return BlazeBurnerBlock.HeatLevel.NONE;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("ValveState", this.valveState);
        compound.putFloat("Heat", this.heat);
        compound.putInt("Tick", this.tick);
        compound.put("FluidContent", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.valveState = compound.getFloat("ValveState");
        this.heat = compound.getFloat("Heat");
        this.tick = compound.getInt("Tick");
        this.tank.readFromNBT(registries, compound.getCompound("FluidContent"));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.BURNER.get(), (be, context) -> {
            if (context == null || context == Direction.DOWN) {
                return be.tank;
            }
            return null;
        });
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.tank);
    }

    public BurnerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }
}

