/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.basin_lid;

import com.jesz.createdieselgenerators.content.basin_lid.BasinFermentingRecipe;
import com.jesz.createdieselgenerators.content.basin_lid.BasinLidBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BasinLidBlockEntity
extends BasinOperatingBlockEntity {
    public boolean steamInside = false;
    public int processingTime;
    public boolean running;
    public float progress;
    private static final Object basinFermentingRecipesKey = new Object();

    public BasinLidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("ProcessingTime", this.processingTime);
        compound.putBoolean("Running", this.running);
        compound.putBoolean("SteamInside", this.steamInside);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.processingTime = compound.getInt("ProcessingTime");
        this.running = compound.getBoolean("Running");
        this.steamInside = compound.getBoolean("SteamInside");
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.processingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (this.currentRecipe != null) {
            this.progress = (float)this.processingTime / (float)((BasinFermentingRecipe)this.currentRecipe).getProcessingDuration();
        } else {
            if (this.processingTime != -1) {
                List recipes = this.getMatchingRecipes();
                if (!recipes.isEmpty()) {
                    this.currentRecipe = (Recipe)recipes.get(0);
                } else {
                    this.processingTime = -1;
                }
            }
            this.progress = 0.0f;
        }
        if (!this.level.isClientSide && (this.currentRecipe == null || this.processingTime == -1) || ((Boolean)this.getBlockState().getValue((Property)BasinLidBlock.OPEN)).booleanValue() || !((Boolean)this.getBlockState().getValue((Property)BasinLidBlock.ON_A_BASIN)).booleanValue()) {
            this.running = false;
            this.processingTime = -1;
            this.basinChecker.scheduleUpdate();
        }
        if (this.running) {
            this.steamInside = true;
        }
        if (this.running && this.level != null) {
            if (!this.level.isClientSide && this.processingTime <= 0) {
                this.processingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (!this.level.isClientSide && this.processingTime % 20 == 0 && new Random().nextInt() % 4 == 0) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.15f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime == 1) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.15f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime > 0) {
                --this.processingTime;
            }
        }
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.level == null) {
            return true;
        }
        if (this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.processingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)recipe;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.processingTime = n;
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.level == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.level.getBlockEntity(this.worldPosition.below(1));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        if (((Boolean)this.getBlockState().getValue((Property)BasinLidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value() instanceof BasinFermentingRecipe;
    }

    protected Object getRecipeCacheKey() {
        return basinFermentingRecipesKey;
    }
}

