/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.core.camera.DetachedCameraController;
import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import com.pedrorok.hypertube.core.placement.TubePlacement;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.core.travel.TravellerEntity;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static long lastTickTime = 0L;
    private static final long TICK_INTERVAL_NS = 16666666L;

    @SubscribeEvent
    public static void onTickPre(ClientTickEvent.Pre event) {
        ClientEvents.onTick(true);
    }

    @SubscribeEvent
    public static void onTickPost(ClientTickEvent.Post event) {
        ClientEvents.onTick(false);
    }

    private static void onTick(boolean isPreEvent) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        if (isPreEvent) {
            TubeSoundManager.tickClientPlayerSounds();
            return;
        }
        TubePlacement.clientTick();
        DetachedCameraController.tickCamera();
    }

    @SubscribeEvent
    public static void renderFrame(RenderFrameEvent.Pre event) {
        long currentTime = System.nanoTime();
        if (currentTime - lastTickTime >= 16666666L) {
            DetachedPlayerDirController.tickPlayer();
            lastTickTime = currentTime;
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.pushPose();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        TubePlacement.drawCustomBlockSelection(ms, (MultiBufferSource)buffer, camera);
        buffer.draw();
        RenderSystem.enableCull();
        ms.popPose();
    }

    protected static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    @SubscribeEvent
    public static void onRenderEntity(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (!entity.getPersistentData().getBoolean("hypertube_travel")) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        TravellerEntity travellerEntity = TravelConstants.Client.ENTITIES_RENDER.get(entity.getType());
        if (travellerEntity == null) {
            travellerEntity = TravellerEntity.ofAny(0.5f);
        }
        travellerEntity.renderEntityOnTube().accept(entity, poseStack);
    }

    @SubscribeEvent
    public static void onRenderEntityPost(RenderLivingEvent.Post event) {
        LivingEntity entity = event.getEntity();
        if (!entity.getPersistentData().getBoolean("hypertube_travel")) {
            return;
        }
        event.getPoseStack().popPose();
    }
}

