/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.linkedtransmitter;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.content.linkedtransmitter.LinkedTransmitterBlock;
import com.hlysine.create_connected.content.linkedtransmitter.LinkedTransmitterBlockEntity;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkedButtonBlock
extends ButtonBlock
implements IBE<LinkedTransmitterBlockEntity>,
SpecialBlockItemRequirement,
IWrenchable,
LinkedTransmitterBlock {
    public static BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    private final ButtonBlock base;

    public LinkedButtonBlock(BlockBehaviour.Properties pProperties, ButtonBlock base) {
        super(base.type, base.ticksToStayPressed, pProperties);
        this.base = base;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{LOCKED}));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Block getBase() {
        return this.base;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)ButtonBlock.FACING);
        return Shapes.or((VoxelShape)this.getTransmitterShape(state), (VoxelShape)super.getShape(state, level, pos, context));
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        return this.base.defaultBlockState().getDrops(builder);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (this.isHittingBase(state, (BlockGetter)level, pos, (HitResult)hit)) {
            if (!player.isShiftKeyDown()) {
                return super.useWithoutItem(state, level, pos, player, hit);
            }
            return InteractionResult.CONSUME;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LOCKED));
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock()) && !isMoving && this.getBlockEntityOptional((BlockGetter)world, pos).map(be -> be.containsBase).orElse(false).booleanValue()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CCItems.LINKED_TRANSMITTER.get()));
        }
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.transmit(0));
        this.base.defaultBlockState().onRemove(world, pos, newState, isMoving);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Player player = context.getPlayer();
        if (!player.isCreative()) {
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)CCItems.LINKED_TRANSMITTER.get()));
        }
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            be.containsBase = false;
        });
        this.replaceWithBase(state, context.getLevel(), context.getClickedPos());
        return InteractionResult.SUCCESS;
    }

    @Override
    public void replaceBase(BlockState baseState, Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)baseState.getValue((Property)FACING)))).setValue((Property)FACE, (Comparable)((AttachFace)baseState.getValue((Property)FACE)))).setValue((Property)POWERED, (Comparable)((Boolean)baseState.getValue((Property)POWERED))));
        AllSoundEvents.CONTROLLER_PUT.playOnServer(world, (Vec3i)pos);
        this.checkPressed(world.getBlockState(pos), world, pos);
    }

    public void replaceWithBase(BlockState state, Level world, BlockPos pos) {
        AllSoundEvents.CONTROLLER_TAKE.playOnServer(world, (Vec3i)pos);
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.transmit(0));
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)this.base.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FACE, (Comparable)((AttachFace)state.getValue((Property)FACE)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED))));
        super.checkPressed(world.getBlockState(pos), world, pos);
    }

    protected void checkPressed(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        super.checkPressed(state, level, pos);
        this.updateTransmittedSignal(level, pos);
    }

    public void press(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @Nullable Player player) {
        super.press(state, level, pos, player);
        this.updateTransmittedSignal(level, pos);
    }

    public void updateTransmittedSignal(Level worldIn, BlockPos pos) {
        if (worldIn.isClientSide) {
            return;
        }
        BlockState state = worldIn.getBlockState(pos);
        int power = state.getSignal((BlockGetter)worldIn, pos, (Direction)state.getValue((Property)FACING));
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> be.transmit(power));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        if (this.isHittingBase(state, (BlockGetter)world, pos, target)) {
            return this.base.getCloneItemStack(state, target, world, pos, player);
        }
        return new ItemStack((ItemLike)CCItems.LINKED_TRANSMITTER.get());
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        requiredItems.add(new ItemStack((ItemLike)this.base));
        requiredItems.add(new ItemStack((ItemLike)CCItems.LINKED_TRANSMITTER.get()));
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, requiredItems);
    }

    public Class<LinkedTransmitterBlockEntity> getBlockEntityClass() {
        return LinkedTransmitterBlockEntity.class;
    }

    public BlockEntityType<? extends LinkedTransmitterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.LINKED_TRANSMITTER.get();
    }
}

