//priority: 1

ServerEvents.recipes((event) => {

	event.remove({ mod: 'immersive_aircraft' })

	//Non-aircraft items that did not get their new recipes from the modfile
	event.shaped(
		Item.of('immersive_aircraft:rotary_cannon', 1),
		[
			' D ',
			'PIW',
			' C '
		],
		{
			D: 'minecraft:dispenser',
			P: 'create:pulse_timer',
			W: 'create:precision_mechanism',
			I: 'immersive_aircraft:industrial_gears',
			C: 'create:copper_casing'
		}
	)

	event.shaped(
		Item.of('immersive_aircraft:telescope', 1),
		[
			' S ',
			' P ',
			' C '
		],
		{
			S: 'minecraft:spyglass',
			P: 'create:precision_mechanism',
			C: 'create:copper_casing'
		}
	)
		
	addCreateRecipeHandler(event);

	//aircraft vehicles

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:airship",
		[
			"SSS ",
			"T T ",
			"HLEP",
			"HHH "
		],
		{
			S: "immersive_aircraft:sail",
			T: "minecraft:string",
			H: "immersive_aircraft:hull",
			L: "#create:seats",
			E: "immersive_aircraft:engine",
			P: "immersive_aircraft:propeller",
		}
	).id("airship")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:cargo_airship",
		[
			"CAC",
			"CSC",
			"HHH"
		],
		{
			C: "minecraft:chest",
			A: "immersive_aircraft:airship",
			S: "create:sturdy_sheet",
			H: "immersive_aircraft:hull",
		}
	).id("cargo_airship")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:warship",
		[
			"RSSSR",
			"RSSSR",
			" T T ",
			"CHAEP",
			" HHH "
		],
		{
			R: "create:railway_casing",
			S: "immersive_aircraft:sail",
			T: "minecraft:string",
			C: "immersive_aircraft:heavy_crossbow",
			H: "immersive_aircraft:hull",
			A: "immersive_aircraft:cargo_airship",
			E: "immersive_aircraft:engine",
			P: "immersive_aircraft:propeller",
		}
	).id("warship")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:biplane",
		[
			"   S ",
			"S  S ",
			"HHLEP",
			"S  S ",
			"   S "
		],
		{
			S: "immersive_aircraft:sail",
			H: "immersive_aircraft:hull",
			L: "#create:seats",
			E: "immersive_aircraft:engine",
			P: "immersive_aircraft:propeller",
		}
	).id("biplane")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:bamboo_hopper",
		[
			"     S ",
			"SHHHHEP",
			"S    S ",
			"SPELLLR",
			"S    S ",
			"SHHHHEP",
			"     S "
		],
		{
			S: "immersive_aircraft:sail",
			H: "immersive_aircraft:hull",
			E: "immersive_aircraft:engine",
			P: "immersive_aircraft:propeller",
			L: "#create:seats",
			R: "create:railway_casing",
		}
	).id("bamboo_hopper")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:gyrodyne",
		[
			" P ",
			"SMS",
			"HLH"
		],
		{
			P: "immersive_aircraft:propeller",
			S: "immersive_aircraft:sail",
			M: "create:precision_mechanism",
			H: "immersive_aircraft:hull",
			L: "#create:seats",
		}
	).id("gyrodyne")

	event.recipes.createMechanicalCrafting(
		"immersive_aircraft:quadrocopter",
		[
			"PBP",
			"BEB",
			"PBP"
		],
		{
			P: "immersive_aircraft:propeller",
			B: "minecraft:scaffolding",
			E: "immersive_aircraft:engine",
		}
	).id("quadrocopter")
	

	event.recipes.create.finalize();

});

	
	//event.remove({ mod: 'immersive_aircraft' })

	//event.custom({
	//	"type": "create:mechanical_crafting",
	//	"key": {
	//		"L": {
	//			"tag": "create:seats"
	//		},
	//		"S": {
	//			"item": "immersive_aircraft:sail"
	//		},
	//		"T": {
	//			"item": "minecraft:string"
	//		},
	//		"H": {
	//			"item": "immersive_aircraft:hull"
	//		},
	//		"E": {
	//			"item": "immersive_aircraft:engine"
	//		},
	//		"P": {
	//			"item": "immersive_aircraft:propeller"
	//		}
	//	},
	//	"pattern": [
	//		"SSS ",
	//		"T T ",
	//		"HLEP",
	//		"HHH "
	//	],
	//	"result": {
	//		"count": 1,
	//		"id": "immersive_aircraft:airship"
    //   }
    //})

// })

	
	 			