/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation;

import com.simibubi.create.AllBlockEntityTypes;
import java.util.List;
import java.util.function.UnaryOperator;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.nbt.NBTProcessors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CreateNBTProcessors {
    public static void register() {
        NBTProcessors.addProcessor((BlockEntityType)BlockEntityType.SIGN, data -> {
            for (int i = 0; i < 4; ++i) {
                if (!NBTProcessors.textComponentHasClickEvent((String)data.getString("Text" + (i + 1)))) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((BlockEntityType)BlockEntityType.LECTERN, data -> {
            if (!data.contains("Book", 10)) {
                return data;
            }
            CompoundTag book = data.getCompound("Book");
            ResourceLocation writableBookResource = BuiltInRegistries.ITEM.getKey((Object)Items.WRITABLE_BOOK);
            if (writableBookResource != BuiltInRegistries.ITEM.getDefaultKey() && book.getString("id").equals(writableBookResource.toString())) {
                return data;
            }
            if (!book.contains("tag", 10)) {
                return data;
            }
            CompoundTag tag = book.getCompound("tag");
            if (!tag.contains("pages", 9)) {
                return data;
            }
            ListTag pages = tag.getList("pages", 8);
            for (Tag inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent((String)inbt.getAsString())) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.CLIPBOARD.get()), CreateNBTProcessors::clipboardProcessor);
        NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.CREATIVE_CRATE.get()), (UnaryOperator)NBTProcessors.itemProcessor((String)"Filter"));
        NBTProcessors.addProcessor((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.PLACARD.get()), (UnaryOperator)NBTProcessors.itemProcessor((String)"Item"));
    }

    public static CompoundTag clipboardProcessor(CompoundTag data) {
        if (!data.contains("Item", 10)) {
            return data;
        }
        CompoundTag book = data.getCompound("Item");
        if (!book.contains("tag", 10)) {
            return data;
        }
        CompoundTag itemData = book.getCompound("tag");
        for (List entries : NBTHelper.readCompoundList((ListTag)itemData.getList("Pages", 10), pageTag -> NBTHelper.readCompoundList((ListTag)pageTag.getList("Entries", 10), tag -> tag.getString("Text")))) {
            for (String entry : entries) {
                if (!NBTProcessors.textComponentHasClickEvent((String)entry)) continue;
                return null;
            }
        }
        return data;
    }
}

