/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.coxinhautilities.common.recipe.drying;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.luligabi.coxinhautilities.common.recipe.drying.DryingRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class DryingRecipeSerializer
implements RecipeSerializer<DryingRecipe> {
    public static final MapCodec<DryingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(DryingRecipe::getIngredient), (App)Codec.INT.optionalFieldOf("dryingTime", (Object)20).forGetter(DryingRecipe::getDryingTime), (App)ItemStack.CODEC.fieldOf("result").forGetter(DryingRecipe::getOutput)).apply((Applicative)instance, DryingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> PACKET_CODEC = StreamCodec.of(DryingRecipeSerializer::toNetwork, DryingRecipeSerializer::fromNetwork);

    private static DryingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
        int dryingTime = buf.readInt();
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        return new DryingRecipe(ingredient, dryingTime, result);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buf, DryingRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getIngredient());
        buf.writeInt(recipe.getDryingTime());
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
    }

    public MapCodec<DryingRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> streamCodec() {
        return PACKET_CODEC;
    }
}

